<?php

/**
 * EmployeeModel
 * This is basically a simple CRUD (Create/Read/Update/Delete) demonstration.
 */
class EmployeeModel
{
    /**
     * Constructor, expects a Database connection
     * @param Database $db The Database object
     */
    public function __construct(Database $db)
    {
        $this->db = $db;
    }
	
	 /*  public function DecryptAllEmp()
    {
        $result = array();
        $count=0; $count1=0; $errorMsg=""; $successMsg=""; $status=false;
        $data = array();
        $orgid = $_SESSION['ubihrm_org_id'];
         $mdate= date('Y-m-d h:i:s');
        $sql1 = "SELECT HomeEmailId, CurrentContactNumber, CurrentEmailId, CurrentAddress, HomeContactNumber, HomeAddress, EmergencyContactNumber, EmergencyAddress, EmergencyEmailId, BankIFSCCode, BankAddress, PersonalNo, CompanyEmail, Id FROM EmployeeMaster";
        $query1 = $this->db->prepare($sql1);
        try{
            $query1->execute(array($orgid));
            $count1 =  $query1->rowCount();
            while($row = $query1->fetch())
            {
            
                $id = $row->Id;
                $HomeEmailId = Utils::encode5t($row->HomeEmailId);
                $CurrentContactNumber = Utils::encode5t($row->CurrentContactNumber);
                $CurrentEmailId = Utils::encode5t($row->CurrentEmailId);
                $CurrentAddress = Utils::encode5t($row->CurrentAddress);
                $HomeContactNumber = Utils::encode5t($row->HomeContactNumber);
                $HomeAddress = Utils::encode5t($row->HomeAddress);
                $EmergencyContactNumber = Utils::encode5t($row->EmergencyContactNumber);
                $EmergencyAddress = Utils::encode5t($row->EmergencyAddress);
                $EmergencyEmailId = Utils::encode5t($row->EmergencyEmailId);
                $BankIFSCCode = Utils::encode5t($row->BankIFSCCode);
                $BankAddress = Utils::encode5t($row->BankAddress);
                $PersonalNo = Utils::encode5t($row->PersonalNo);
                $CompanyEmail = Utils::encode5t($row->CompanyEmail);
               
                $sql = "UPDATE EmployeeMaster SET  HomeEmailId=?, CurrentContactNumber=?,CurrentEmailId=?,CurrentAddress=?,HomeContactNumber=?,HomeAddress=?,EmergencyContactNumber=?,EmergencyEmailId=?,EmergencyAddress=?,BankIFSCCode=?,BankAddress=?,PersonalNo=?,CompanyEmail=? WHERE Id=?";
        
                $query = $this->db->prepare($sql);
                $query->execute(array($HomeEmailId,$CurrentContactNumber,$CurrentEmailId,$CurrentAddress,$HomeContactNumber,$HomeAddress,$EmergencyContactNumber,$EmergencyEmailId,$EmergencyAddress,$BankIFSCCode,$BankAddress,$PersonalNo,$CompanyEmail, $id));            
            }
        }catch(Exception $e) {
            $errorMsg = 'Message: ' .$e->getMessage();
        }
        
    }  */
	 /* public function DecryptEmpDetails()
    {
        $result = array();
        $count=0; $count1=0; $errorMsg=""; $successMsg=""; $status=false;
        $data = array();
        $orgid = $_SESSION['ubihrm_org_id'];
        $mdate= date('Y-m-d h:i:s');
        $sql1 = "SELECT IBAN, SwiftCode, Branch, Id from EmployeeBankDetails";
        $query1 = $this->db->prepare($sql1);
        try{
             $query1->execute();
            $count1 =  $query1->rowCount();
            while($row = $query1->fetch())
            {
                $id = $row->Id;
                $IBAN = Utils::encode5t($row->IBAN);
                $SwiftCode = Utils::encode5t($row->SwiftCode);
                $Branch = Utils::encode5t($row->Branch);
                $sql = "UPDATE EmployeeBankDetails SET  IBAN=?, SwiftCode=?,Branch=? WHERE Id=?";
        
                $query = $this->db->prepare($sql);
                $query->execute(array($IBAN,$SwiftCode,$Branch, $id));            
            }
			$sql2 = "SELECT LoanAmount, Tenure, EMI, Id from EmployeeBankLoan";
			$query2 = $this->db->prepare($sql2);
			$query2->execute();
            $count2 =  $query2->rowCount();
            while($row = $query2->fetch())
            {
                $id = $row->Id;
                $LoanAmount = Utils::encode5t($row->LoanAmount);
                $Tenure = Utils::encode5t($row->Tenure);
                $EMI = Utils::encode5t($row->EMI);
                $sql = "UPDATE EmployeeBankLoan SET  LoanAmount=?, Tenure=?,EMI=? WHERE Id=?";
        
                $query = $this->db->prepare($sql);
                $query->execute(array($LoanAmount,$Tenure,$EMI, $id));            
            }	
			
			$sql3 = "SELECT CreditCardNo, Id from EmployeeCreditCard";
			$query3 = $this->db->prepare($sql3);
			$query3->execute();
            $count3 =  $query3->rowCount();
            while($row = $query3->fetch())
            {
                $id = $row->Id;
                $CreditCardNo = Utils::encode5t($row->CreditCardNo);
              
                $sql = "UPDATE EmployeeCreditCard SET  CreditCardNo=? WHERE Id=?";
        
                $query = $this->db->prepare($sql);
                $query->execute(array($CreditCardNo, $id));            
            }
			
			$sql4 = "SELECT Contact, Id from EmployeeDependant";
			$query4 = $this->db->prepare($sql4);
			$query4->execute();
            $count4 =  $query4->rowCount();
            while($row = $query4->fetch())
            {
                $id = $row->Id;
                $Contact = Utils::encode5t($row->Contact);
               
                $sql = "UPDATE EmployeeDependant SET  Contact=? WHERE Id=?";
        
                $query = $this->db->prepare($sql);
                $query->execute(array($Contact, $id));            
            }
			
			$sql5 = "SELECT DocumentNumber, Id from EmployeeDocument";
			$query5 = $this->db->prepare($sql5);
			$query5->execute();
            $count5 =  $query5->rowCount();
            while($row = $query5->fetch())
            {
                $id = $row->Id;
                $DocumentNumber = Utils::encode5t($row->DocumentNumber);
             
                $sql = "UPDATE EmployeeDocument SET  DocumentNumber=? WHERE Id=?";
        
                $query = $this->db->prepare($sql);
                $query->execute(array($DocumentNumber, $id));            
            }
			
			$sql5 = "SELECT PassportNo, EmiratesId, Id from EmployeeLTADetail";
			$query5 = $this->db->prepare($sql5);
			$query5->execute();
            $count5 =  $query5->rowCount();
            while($row = $query5->fetch())
            {
                $id = $row->Id;
                $PassportNo = Utils::encode5t($row->PassportNo);
                $EmiratesId = Utils::encode5t($row->EmiratesId);
              
                $sql = "UPDATE EmployeeLTADetail SET  PassportNo=?, EmiratesId=? WHERE Id=?";
        
                $query = $this->db->prepare($sql);
                $query->execute(array($PassportNo, $EmiratesId, $id));            
            } 
			$sql6 = "SELECT Contact, Email, Id from EmployeeReference";
			$query6 = $this->db->prepare($sql6);
			$query6->execute();
            $count6 =  $query6->rowCount();
            while($row = $query6->fetch())
            {
                $id = $row->Id;
                $Contact = Utils::encode5t($row->Contact);
                $Email = Utils::encode5t($row->Email);
              
                $sql = "UPDATE EmployeeReference SET  Contact=?, Email=? WHERE Id=?";
        
                $query = $this->db->prepare($sql);
                $query->execute(array($Contact, $Email, $id));            
            }
			
			
        }catch(Exception $e) {
            $errorMsg = 'Message: ' .$e->getMessage();
        }
        
    }  */
	//to encrypt all user email////
	
	 /* public function DecryptAllUser()
    {
        $result = array();
        $count=0; $count1=0; $errorMsg=""; $successMsg=""; $status=false;
        $data = array();
        $orgid = $_SESSION['ubihrm_org_id'];
         $mdate= date('Y-m-d h:i:s');
        $sql1 = "SELECT Username, Id FROM UserMaster";
        $query1 = $this->db->prepare($sql1);
        try{
            $query1->execute(array($orgid));
            $count1 =  $query1->rowCount();
            while($row = $query1->fetch())
            {
            
                $id = $row->Id;
                $Username = Utils::encode5t($row->Username);
                
               
                $sql = "UPDATE UserMaster SET  Username=? WHERE Id=?";
        
                $query = $this->db->prepare($sql);
                $query->execute(array($Username, $id));            
            }
        }catch(Exception $e) {
            $errorMsg = 'Message: ' .$e->getMessage();
        }
        
    }  */
	///////to encrypt all new employee/////////
	/*  public function DecryptAllNewEmp()
    {
        $result = array();
        $count=0; $count1=0; $errorMsg=""; $successMsg=""; $status=false;
        $data = array();
        $orgid = $_SESSION['ubihrm_org_id'];
         $mdate= date('Y-m-d h:i:s');
        $sql1 = "SELECT HomeEmailId, CurrentContactNumber, CurrentEmailId, CurrentAddress, HomeContactNumber, HomeAddress, EmergencyContactNumber, EmergencyAddress, EmergencyEmailId, BankIFSCCode, BankAddress, Id FROM EmployeeNewJoinee";
        $query1 = $this->db->prepare($sql1);
        try{
            $query1->execute(array($orgid));
            $count1 =  $query1->rowCount();
            while($row = $query1->fetch())
            {
            
                $id = $row->Id;
                $HomeEmailId = Utils::encode5t($row->HomeEmailId);
                $CurrentContactNumber = Utils::encode5t($row->CurrentContactNumber);
                $CurrentEmailId = Utils::encode5t($row->CurrentEmailId);
                $CurrentAddress = Utils::encode5t($row->CurrentAddress);
                $HomeContactNumber = Utils::encode5t($row->HomeContactNumber);
                $HomeAddress = Utils::encode5t($row->HomeAddress);
                $EmergencyContactNumber = Utils::encode5t($row->EmergencyContactNumber);
                $EmergencyAddress = Utils::encode5t($row->EmergencyAddress);
                $EmergencyEmailId = Utils::encode5t($row->EmergencyEmailId);
                $BankIFSCCode = Utils::encode5t($row->BankIFSCCode);
                $BankAddress = Utils::encode5t($row->BankAddress);
              
                $sql = "UPDATE EmployeeNewJoinee SET  HomeEmailId=?, CurrentContactNumber=?,CurrentEmailId=?,CurrentAddress=?,HomeContactNumber=?,HomeAddress=?,EmergencyContactNumber=?,EmergencyEmailId=?,EmergencyAddress=?,BankIFSCCode=?,BankAddress=? WHERE Id=?";
        
                $query = $this->db->prepare($sql);
                $query->execute(array($HomeEmailId,$CurrentContactNumber,$CurrentEmailId,$CurrentAddress,$HomeContactNumber,$HomeAddress,$EmergencyContactNumber,$EmergencyEmailId,$EmergencyAddress,$BankIFSCCode,$BankAddress, $id));            
            }
        }catch(Exception $e) {
            $errorMsg = 'Message: ' .$e->getMessage();
        }
        
    }  */
	
	/* public function DecryptNewEmpDetails()
    {
        $result = array();
        $count=0; $count1=0; $errorMsg=""; $successMsg=""; $status=false;
        $data = array();
        $orgid = $_SESSION['ubihrm_org_id'];
        $mdate= date('Y-m-d h:i:s');
        $sql1 = "SELECT Email, Contact, Id from EmployeeNewJoiningReference";
        $query1 = $this->db->prepare($sql1);
        try{
             $query1->execute();
            $count1 =  $query1->rowCount();
            while($row = $query1->fetch())
            {
                $id = $row->Id;
                $Email = Utils::encode5t($row->Email);
                $Contact = Utils::encode5t($row->Contact);
                
                $sql = "UPDATE EmployeeNewJoiningReference SET  Email=?, Contact=? WHERE Id=?";
        
                $query = $this->db->prepare($sql);
                $query->execute(array($Email,$Contact, $id));            
            }
			
			$sql5 = "SELECT DocumentNumber, Id from EmployeeNewJoiningDocument";
			$query5 = $this->db->prepare($sql5);
			$query5->execute();
            $count5 =  $query5->rowCount();
            while($row = $query5->fetch())
            {
                $id = $row->Id;
                $DocumentNumber = Utils::encode5t($row->DocumentNumber);
             
                $sql = "UPDATE EmployeeNewJoiningDocument SET  DocumentNumber=? WHERE Id=?";
        
                $query = $this->db->prepare($sql);
                $query->execute(array($DocumentNumber, $id));            
            }
			
			
			
			
        }catch(Exception $e) {
            $errorMsg = 'Message: ' .$e->getMessage();
        }
        
    } */
	
	
    /**
     * Get method for fetching the records of department
     * @return array an array with several objects (the results)
     */
    public function getAll($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		
        $sql = "SELECT * FROM EmployeeMaster WHERE OrganizationId = :id and (DOL='0000-00-00' or DOL>curdate()) ";
        $query = $this->db->prepare($sql);
		try{
			
			$query->execute(array(':id' => $orgid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['name'] = $row->EmployeeCode." - ". ucwords(strtolower($row->FirstName." ".$row->LastName));
				$res['empcode'] = $row->EmployeeCode;
				$res['empfname'] = $row->FirstName;
				$res['emplname'] = $row->LastName;
				$res['empdob'] = $row->DOB;
				$res['empnation'] = $row->Nationality;
				$res['empgender'] = $row->Gender;
				$res['empcdate'] = $row->CreatedDate;
				$res['empmdate'] = $row->LastModifiedDate;
				$res['image'] = $row->ImageName;
				$res['sts']=0;
				
				$data[] = $res;
			}
        }else{
			$status=true;
			$successMsg = EMPLOYEE_MODULE_GETALL;
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
	public function getSeniorEmployeeList($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			
		$ids = Utils::getSeniorIds($mid, $this->db);
		
        $sql = "SELECT * FROM EmployeeMaster WHERE OrganizationId = :id and Id in ($ids) and (DOL='0000-00-00' or DOL>curdate()) order by FirstName";
        $query = $this->db->prepare($sql);
		try{
			
			$query->execute(array(':id' => $orgid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = $row->Id;
				$res['name'] = $row->EmployeeCode." - ". ucwords(strtolower($row->FirstName." ".$row->LastName));
				$res['empcode'] = $row->EmployeeCode;
				$res['empfname'] = $row->FirstName;
				$res['emplname'] = $row->LastName;
				$res['empdob'] = $row->DOB;
				$res['empnation'] = $row->Nationality;
				$res['empgender'] = $row->Gender;
				$res['empcdate'] = $row->CreatedDate;
				$res['empmdate'] = $row->LastModifiedDate;
				$res['image'] = $row->ImageName;
				$res['sts']=0;
				
				$data[] = $res;
			}
        }else{
			$status=true;
			$successMsg = EMPLOYEE_MODULE_GETALL;
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
	
	public function getAllHierarchyEmployee($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$sts=$_SESSION['ubihrm_user_sts'];
		$hrsts=$_SESSION['ubihrm_hr_sts'];
		$sql = "";
		if($sts==1 || $hrsts==1){
			//$ids =Utils::getReportingIds($mid, $this->db); 
			$sql = "SELECT * FROM EmployeeMaster WHERE OrganizationId = :id and (DOL='0000-00-00' or DOL>curdate()) order by FirstName ";
			
		}	
		else{		
			$ids =Utils::getReportingIds($mid, $this->db);
			$sql = "SELECT * FROM EmployeeMaster WHERE OrganizationId = :id and (DOL='0000-00-00' or DOL>curdate()) and Id in ($ids) order by FirstName ";
		}	
		$query = $this->db->prepare($sql);
			try{
				
				$query->execute(array(':id' => $orgid ));
				$count =  $query->rowCount();
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = (int)$row->Id;
				$res['doj'] = $row->DOJ;
				$res['name'] = $row->EmployeeCode." - ". ucwords(strtolower($row->FirstName." ".$row->LastName));
				$res['sts'] = 0;
				$res['empreport'] = Utils::getName($row->ReportingTo,"EmployeeMaster", "FirstName", $this->db).' '.Utils::getName($row->ReportingTo,"EmployeeMaster", "LastName", $this->db);
				$res['empdivision'] = Utils::getName($row->Division,"DivisionMaster", "Name", $this->db);
				$res['empdepartment'] = Utils::getName($row->Department,"DepartmentMaster", "Name", $this->db);
				$res['empdesignation'] = Utils::getName($row->Designation,"DesignationMaster", "Name", $this->db);
				$res['empchannel'] = Utils::getName($row->Channel,"ChannelMaster", "Name", $this->db);
				$res['empgrade'] = Utils::getName($row->Grade,"GradeMaster", "Name", $this->db);
				$res['empsts'] = Utils::getOtherName($row->EmployeeStatus,"EmployeeStatus", $this->db);
				$res['empsts1'] = $row->EmployeeStatus;
				$res['salaryctc'] = $row->EmployeeCTC;
				$res['emplocation'] = Utils::getName($row->Location,"LocationMaster", "Name", $this->db);
				$res['empcurency'] =  Utils::getDivisioncurrency($row->Division,$this->db);
				//$res['empgratuity']=round(Utils::getEmployeeGratuity($row->Id,1,$this->db));
				$data[] = $res;
			}
        }else{
			$status=true;
			$successMsg = EMPLOYEE_MODULE_GETALL;
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	public function getAllHierarchyEmployee1($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$sts=$_SESSION['ubihrm_user_sts'];
		$hrsts=$_SESSION['ubihrm_hr_sts'];
		$sql = "";
		
		$ids =Utils::getReportingIds($mid, $this->db);
			$sql = "SELECT * FROM EmployeeMaster WHERE OrganizationId = :id and (DOL='0000-00-00' or DOL>curdate()) and Id in ($ids) order by FirstName ";
			
		$query = $this->db->prepare($sql);
			try{
				
				$query->execute(array(':id' => $orgid ));
				$count =  $query->rowCount();
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = (int)$row->Id;
				$res['name'] = $row->EmployeeCode." - ". ucwords(strtolower($row->FirstName." ".$row->LastName));
				$res['sts'] = 0;
				$res['empreport'] = Utils::getName($row->ReportingTo,"EmployeeMaster", "FirstName", $this->db).' '.Utils::getName($row->ReportingTo,"EmployeeMaster", "LastName", $this->db);
				$res['empdivision'] = Utils::getName($row->Division,"DivisionMaster", "Name", $this->db);
				$res['empdepartment'] = Utils::getName($row->Department,"DepartmentMaster", "Name", $this->db);
				$res['empdesignation'] = Utils::getName($row->Designation,"DesignationMaster", "Name", $this->db);
				$res['empchannel'] = Utils::getName($row->channel,"ChannelMaster", "Name", $this->db);
				$res['empgrade'] = Utils::getName($row->Grade,"GradeMaster", "Name", $this->db);
				$res['empsts'] = Utils::getOtherName($row->EmployeeStatus,"EmployeeStatus", $this->db);
				$res['empsts1'] = $row->EmployeeStatus;
				$res['salaryctc'] = $row->EmployeeCTC;
				$res['emplocation'] = Utils::getName($row->Location,"LocationMaster", "Name", $this->db);
				//$res['empgratuity']=round(Utils::getEmployeeGratuity($row->Id,1,$this->db));
				$data[] = $res;
			}
        }else{
			$status=true;
			$successMsg = EMPLOYEE_MODULE_GETALL;
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	public function getAllHierarchyEmployeeWithData($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$sts=$_SESSION['ubihrm_user_sts'];
		$sql = "";
		if($sts==1){
			//$ids =Utils::getReportingIds($mid, $this->db);
			$sql = "SELECT * FROM EmployeeMaster WHERE OrganizationId = :id and (DOL='0000-00-00' or DOL>curdate()) order by FirstName";
			
		}	
		else{		
			$ids =Utils::getReportingIds($mid, $this->db);
			$sql = "SELECT * FROM EmployeeMaster WHERE OrganizationId = :id and Id in ($ids) and (DOL='0000-00-00' or DOL>curdate()) order by FirstName";
			
		}	
		$query = $this->db->prepare($sql);
			try{
				
				$query->execute(array(':id' => $orgid ));
				$count =  $query->rowCount();
			
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = (int)$row->Id;
				$res['firstname'] = $row->FirstName;
				$res['lastname'] = $row->LastName;
				$res['name'] = $row->EmployeeCode." - ". ucwords(strtolower($row->FirstName." ".$row->LastName));
				$res['sts'] = 0;
				$res['empdivision'] = Utils::getName($row->Division,"DivisionMaster", "Name", $this->db);
				$res['empdepartment'] = Utils::getName($row->Department,"DepartmentMaster", "Name", $this->db);
				$res['empdesignation'] = Utils::getName($row->Designation,"DesignationMaster", "Name", $this->db);
				$res['empchannel'] = Utils::getName($row->channel,"ChannelMaster", "Name", $this->db);
				$res['reportingto'] = Utils::getEmployeeName($row->ReportingTo, $this->db);
				$res['salaryctc'] = $row->EmployeeCTC;
				$res['empsts'] = Utils::getOtherName($row->EmployeeStatus,"EmployeeStatus", $this->db);
				$res['empdoc'] =Utils::dateformatter($row->DOC); 
				$res['empgrade'] = Utils::getName($row->Grade,"GradeMaster", "Name", $this->db);
				$res['dob'] = Utils::dateformatter($row->DOB);
			    $res['doj'] = Utils::dateformatter($row->DOJ);
			    $res['empcurency'] =  Utils::getDivisioncurrency($row->Division,$this->db);
				//$res['doj'] = $row->DOJ;
				//$res['todaydate'] = Utils::dateformatter(date('Y-m-d'));
				$res1['doc'] = Utils::dateformatter($row->DOC);
				$data[] = $res;
			}
        }else{
			$status=true;
			$successMsg = EMPLOYEE_MODULE_GETALL;
		}
		}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
	public function getAllReportingEmp($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			$parentid=$request[2];
					
		try{
			if($parentid!="0" && $parentid!="")
			{
				$status=true;
				while($parentid!="")
				{
					
					$sql1 = "SELECT RoleId FROM DesignationMaster WHERE OrganizationId = ? and Id in ( $parentid ) ";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array($orgid));
					$count=$query1->rowCount();
					$parentid="";
					while($row1 = $query1->fetch())
					{
						if($parentid==""){
							$parentid = $row1->RoleId;
						}else{
							$parentid .= ", ".$row1->RoleId;
						}
						if($row1->RoleId != 0){
							$desig=$row1->RoleId;
						
							$sql2 = "SELECT * FROM EmployeeMaster WHERE Designation = :id and (DOL='0000-00-00' or DOL>curdate()) and Id <> $request[3] order by FirstName ";
							$query2 = $this->db->prepare($sql2);
							$query2->execute(array(':id' => $desig ));	
							while($row2 = $query2->fetch())
							{
								$res = array();
								$res['id']=$row2->Id;
								$res['name'] = $row2->EmployeeCode." - ". ucwords(strtolower($row2->FirstName." ".$row2->LastName));
								$res['designation']=$row2->Designation;
								$data[] = $res;
							}
						}
					
					}
				
				}
			
			}else{
				$status=true;
				$successMsg = "record not found";
			}
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		//$result['benefit']=$gradebenefit;
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
	
	public function getConfirmDetail($arr)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$orgid = $_SESSION['ubihrm_org_id'];
		$id = Utils::decode5t($arr[2]);
		
        $sql = "SELECT * FROM EmployeeMaster WHERE Id = ? ";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array( $id ));
			$count =  $query->rowCount();
		
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{	
				
				$res = array();
				$res['emppic']="";
				$res['id'] = $row->Id;
				$res['empcode'] = $row->EmployeeCode;
				$res['probation'] = $row->ProvisionPeriod." Months";
				$res['name'] = $row->FirstName." ".$row->MiddleName." ".$row->LastName;
				$res['division'] = Utils::getName($row->Division, 'DivisionMaster', 'Name', $this->db);
				$res['designation'] = Utils::getName($row->Division, 'DivisionMaster', 'Name', $this->db);
				$res['reportto'] = Utils::getEmployeeName($row->ReportingTo, $this->db);
				$res['empsts'] = Utils::getOtherName($row->EmployeeStatus, 'EmployeeStatus', $this->db);
				$res['doj'] = Utils::dateformatter($row->DOJ);
				$res['doc'] = Utils::dateformatter(date("Y-m-d", strtotime(date($row->DOJ).", ".$row->ProvisionPeriod." month")));
				$res['doc1'] = date("Y-m-d", strtotime(date($row->DOJ).", ".$row->ProvisionPeriod." month"));
				$data[] = $res;
			}
		}
		}catch(Exception $e){ 
			$status = false;
			$errorMsg =$e->getMessage();
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
	}	
	
	
	public function getEmployeeChecklist($empid)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$orgid = $_SESSION['ubihrm_org_id'];
		try{
				$sql = "SELECT * FROM ChecklistMaster WHERE CategoryId = 1 and OrganizationId=?";
				$query = $this->db->prepare($sql);
				$query->execute(array($orgid));
				$count=$query->rowCount();
				while($row = $query->fetch())
				{	
					$res = array();
					$sql1 = "SELECT * FROM EmployeeChecklist WHERE EmployeeId = ? and ChecklistId=?";
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array($empid,$row->Id));
					if($query1->rowCount()>0){
						while($row1=$query1->fetch()){
							$res = array();
							$res['id'] = $row1->Id;
							$res['name'] = $row1->Name;
							$res['categoryid'] = $row1->CategoryId;
							$res['sts'] = $row1->Sts;
							$res['checklistid'] = $row1->ChecklistId;
							
							$data[] = $res;
						}
					}else{
						$res['id'] = 0;
						$res['name'] = $row->Name;
						$res['categoryid'] = $row->CategoryId;
						$res['sts'] = 0;
						$res['checklistid'] = $row->Id;
						
						$data[] = $res;
					}
				}
				if($count>0)
				{
					$status=true;
					$successMsg=$count." record found";
				}
				
		}catch(Exception $e){ 
			$status = false;
			$errorMsg =$e->getMessage();
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
	}	
	
	public function saveEmpChecklist($empid)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		        
		try{
			// INSERTING AND UPDATING FamilyDetail OF EMPLOYEE IF PASSED AS AN JSON
			$checklistarr = json_decode($_POST['checklist'], true); 
			
			for($i=0; $i<count($checklistarr); $i++)
			{
				if($checklistarr[$i]['name']!="" && $checklistarr[$i]['categoryid']!="" ){
					$record = array();
					$record[0] = $empid;
					$record[1] = $checklistarr[$i]['name'];
					$record[2] =$checklistarr[$i]['sts'];
					$record[3] = $checklistarr[$i]['categoryid'];
					$record[4] = $checklistarr[$i]['checklistid'];
					$id=$checklistarr[$i]['id'];
					if($id){
						$sqlwork = " Update EmployeeChecklist set EmployeeId=?, Name=?, Sts=?, CategoryId=?,ChecklistId=? where Id=?";
						$querywork = $this->db->prepare($sqlwork);
						$querywork->execute(array($empid,$checklistarr[$i]['name'],$checklistarr[$i]['sts'],$checklistarr[$i]['categoryid'],$checklistarr[$i]['checklistid'],$id));
					}
					else{	
						$sqlwork = " INSERT INTO EmployeeChecklist ( EmployeeId, Name, Sts, CategoryId,ChecklistId) values (?,?,?,?,?)";
						$querywork = $this->db->prepare($sqlwork);
						$querywork->execute($record);
					}
				}
			}		
		
			$count=$querywork->rowCount();
			
			if($count>=1)
			{
				$status=true;
				$successMsg="Checklist Saved";
			}
			else{
				$status=false;
				$errorMsg=EMPLOYEE_MODULE_CREATION_FAILED;
			}
		}catch(Exception $e){ 
			$status = false;
			$errorMsg =$e->getMessage();
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
	}	
	
	public function getDetail($id)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$orgid = $_SESSION['ubihrm_org_id'];
					
        $sql = "SELECT *, TIMESTAMPDIFF(YEAR, DOJ, CURDATE()) as curyear, TIMESTAMPDIFF(MONTH, DOJ, CURDATE()) as curmonth FROM EmployeeMaster WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			$count =  $query->rowCount();
		
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{	
				
				$res = array();
				$res['emppic']="";
				$res['id'] = $row->Id;
				$res['curyear'] = ((int)$row->curyear < 0)?0:(int)$row->curyear;
				$res['curmonth'] = ((int)$row->curmonth < 0)?0:(int)$row->curmonth;
				$year=($res['curyear'] * 12);
				$res['curmonth']=$res['curmonth'] - $year;
				$res['empcode'] = $row->EmployeeCode;
				$res['empfname'] = $row->FirstName;
				$res['empmname'] = $row->MiddleName;
				$res['emplname'] = $row->LastName;
				$dob=$res['empdob'] =Utils::dateformatter($row->DOB) ;
				$res['empnation'] = $row->Nationality;
				$res['empgender'] = $row->Gender;
				$res['empmarists'] = $row->MaritalStatus;
				$res['empreligion'] = $row->Religion;
				$res['empbloodgroup'] = $row->BloodGroup;
				$res['emplang'] = $row->KnownLanguage;
				$doj=$res['empdoj'] = Utils::dateformatter($row->DOJ);
				$doc=$res['empdoc'] =Utils::dateformatter($row->DOC); 
				$res['empvisa'] = $row->Visa;
				$res['empcnumber'] = (int)Utils::decode5t($row->CurrentContactNumber);
				$res['empcemail'] = Utils::decode5t($row->CurrentEmailId);
				$res['empcaddres'] = Utils::decode5t($row->CurrentAddress);
				$res['empccountry'] = $row->CurrentCountry;
				$res['empccity'] = $row->CurrentCity;
				$res['empczip'] = $row->CurrentZipCode;
				$res['emphnumber'] = (int)Utils::decode5t($row->HomeContactNumber);
				$res['emphemail'] = Utils::decode5t($row->HomeEmailId);
				$res['emphaddres'] = Utils::decode5t($row->HomeAddress);
				$res['emphcountry'] = $row->HomeCountry;
				$res['emphcity'] = $row->HomeCity;
				$res['emphzip'] = $row->HomeZipCode;
				$res['empenumber'] = (int)Utils::decode5t($row->EmergencyContactNumber);
				$res['empeemail'] = Utils::decode5t($row->EmergencyEmailId);
				$res['empeaddress'] = Utils::decode5t($row->EmergencyAddress);
				$res['empecountry'] = $row->EmergencyCountry;
				$res['empecity'] = $row->EmergencyCity;
				$res['empezip'] = $row->EmergencyZipCode;
				$res['empreport'] = $row->ReportingTo;
				$res['empdivision'] = $row->Division;
				$res['empcurency'] = Utils::getDivisioncurrency($row->Division,$this->db);
				$res['empdepartment'] = $row->Department;
				$res['empdesignation'] = $row->Designation;
				$res['emplocation'] = $row->Location;
				$res['empshift'] = $row->Shift;
				$res['empsts'] = $row->EmployeeStatus;
				$grade=$res['empgrade'] = $row->Grade;
				$res['empworkday'] = $row->WorkingDays;
				$res['empcreateby'] = $row->CreatedById;
				$res['empmodifiedby'] = $row->LastModifiedById;
				$res['empownerid'] = $row->OwnerId;
				$res['empcdate'] = $row->CreatedDate;
				$res['empmdate'] = $row->LastModifiedDate;
				$res['empfuncarea'] = $row->FunctionalArea;
				$res['salaryctc'] = $row->EmployeeCTC;
				$res['empepaypattern'] = $row->PayPattern;
				$res['empebankname'] = $row->BankName;
				$res['empebankcode'] = Utils::decode5t($row->BankIFSCCode);
				$res['salarytype'] = $row->BankAccount;
				$res['empebankaddress'] = Utils::decode5t($row->BankAddress);
				$res['emptype'] = $row->EmploymentType;
				$res['personal_no'] = (int)Utils::decode5t($row->PersonalNo);
				$res['annualleave'] = Utils::getannualleaves($row->Id,$this->db);
				$res['overtimepay'] = $row->OvertimePayment;
				$res['empchannel'] = $row->Channel;
				$res['empcostcentre'] = $row->CostCentre;
				
	
				if($row->TotalExp!=""){
					$exp = explode(',',$row->TotalExp);
					$y=$exp[0] + $res['curyear'];
					$m=$exp[1] + $res['curmonth'];
					$res['totalexp'] = $y.','.$m;
				}
				else{
					$res['totalexp'] = $res['curyear'].','.$res['curmonth'];
				}
				$res['empexp'] = $row->TotalExp;
				$res['cmpemail'] = Utils::decode5t($row->CompanyEmail);
				$res['airticket'] = $row->AirTicket;
				$res['ticketclass'] = $row->TicketClass;
				$res['oncein'] = $row->OnceIn;
				$res['ticketamt'] = $row->LastTicketAmt;
				$res['iatafare'] = $row->IATAFare;
				$res['instructions'] = $row->TravelInstruction;
				$res['nearestairport'] = $row->NearestAirport;
				$res['provision'] = $row->ProvisionPeriod;
				$res['familydetails'] = $row->FamilyDetail;
				
				
				
				if($row->DOB =="0000-00-00" ){
					$res['empdob']="";
				}
				if($row->DOJ=="0000-00-00" ){
					$res['empdoj']="";
				}
				if($row->DOC=="0000-00-00" ){
					$res['empdoc']="";
				}
				
				$image= $row->ImageName;
				
				if (file_exists( "public/uploads/$orgid/$image")) {
					$res['emppic']= URL."public/uploads/$orgid/$image";
				}
				if($image == ""){
					if($res['empgender']== 1)
					{
						$res['emppic']= URL."public/avatars/male.png";
					}
					else{
						$res['emppic']= URL."public/avatars/female.png";
					}
				
				}
				$work = array();
				$ref  = array();
				$qual = array();
				$doc  = array();
				$companydoc  = array();
				$depen  = array();
				$skill = array();
				$creditcard = array();
				$insurance = array();
				$bank = array();
				$bankloan = array();
				$ltadetails= array();
				$checklistarr= array();
				$referencearr=array();
				
				$sqlwork = "SELECT * FROM EmployeeWorkExperience WHERE EmployeeId = :id";
				$querywork = $this->db->prepare($sqlwork);
				$querywork->execute(array(':id' => $id ));
				while($rowwork = $querywork->fetch())
				{
					$res1 = array();
					$res1['id'] = $rowwork->Id;
					$res1['name'] = $rowwork->CompanyName;
					$res1['desig'] = $rowwork->Designation;				
					$res1['desc'] = $rowwork->Description;
					
					if($rowwork->FromDate =="0000-00-00" ){
					$res1['fdate'] ="";
					}
					else{
						$res1['fdate'] = Utils::dateformatter($rowwork->FromDate);
					}
					if($rowwork->ToDate =="0000-00-00" ){
					$res1['tdate'] ="";
					}
					else{
						$res1['tdate'] = Utils::dateformatter($rowwork->ToDate);
					}
					
					
					
					$work[] = $res1;
				}
				
				
				
				$sqlref = "SELECT * FROM EmployeeReference WHERE EmployeeId = :id";
				$queryref = $this->db->prepare($sqlref);
				$queryref->execute(array(':id' => $id ));
				while($rowref = $queryref->fetch())
				{
					$res1 = array();
					$res1['id'] = $rowref->Id;
					$res1['name'] = $rowref->Name;
					$res1['company'] = $rowref->Company;
					$res1['email'] = Utils::decode5t($rowref->Email);
					$res1['contact'] = (int)Utils::decode5t($rowref->Contact);
					$referencearr[] = $res1;
				}
				$sqlchk = "SELECT * FROM EmployeeChecklist WHERE EmployeeId = :id";
				$querychk = $this->db->prepare($sqlchk);
				$querychk->execute(array(':id' => $id ));
				while($rowchk = $querychk->fetch())
				{
					$res1 = array();
					$res1['id'] = $rowchk->Id;
					$res1['name'] = $rowchk->Name;
					$res1['categoryid'] = $rowchk->CategoryId;
					$res1['sts'] = $rowchk->Sts;
					
					$checklistarr[] = $res1;
				}
				$sqlqual = "SELECT * FROM EmployeeQualification WHERE EmployeeId = :id";
				$queryqual = $this->db->prepare($sqlqual);
				$queryqual->execute(array(':id' => $id ));
				while($rowqual = $queryqual->fetch())
				{
					$res1 = array();
					$res1['id'] = $rowqual->Id;
					$res1['name'] = $rowqual->InstituteName;
					$res1['desig'] = $rowqual->Degree;
					$res1['fdate'] = $rowqual->FOS;
					$res1['tdate'] = Utils::dateformatter($rowqual->DOC);
					$res1['desc'] = $rowqual->GPA;
					
					if($rowqual->DOC =="0000-00-00" ){
					$res1['tdate'] ="";
					}
					$qual[] = $res1;
				}
				
				$sqldoc = "SELECT * FROM EmployeeDocument WHERE EmployeeId = :id";
				$querydoc = $this->db->prepare($sqldoc);
				$querydoc->execute(array(':id' => $id ));
				while($rowdoc = $querydoc->fetch())
				{
					if($rowdoc->DocType==1){
					$res1 = array();
					$docid=$res1['id'] = $rowdoc->Id;
					$res1['name'] = $rowdoc->DocumentTypeId;
					$res1['desig'] = Utils::decode5t($rowdoc->DocumentNumber);
					$res1['fdate'] =Utils::dateformatter($rowdoc->IssuedOn);
					$res1['tdate'] = Utils::dateformatter($rowdoc->ExpiredOn);
					$res1['desc'] = "";
					$res1['originaldoc'] = (int)$rowdoc->OriginalDocSts;
					$res1['doctype'] = (int)$rowdoc->DocType;
					if($rowdoc->IssuedOn =="0000-00-00" ){
					$res1['fdate'] ="";
					}
					if($rowdoc->ExpiredOn =="0000-00-00" ){
					$res1['tdate'] ="";
					}
					
					$code= $this->getCode($rowdoc->EmployeeId);
					$doc1="$code".'_'."$docid";
					$dir="public/uploads/$orgid/$code";
					$filename="";
					if (is_dir($dir)) {
						if ($dh = opendir($dir)) {
							while (($file = readdir($dh)) != false) {
								$filename=$file;
								$ext = pathinfo($filename, PATHINFO_EXTENSION);
								if($filename=="$doc1.$ext")
								{
									$res1['empdoc']=URL."public/uploads/$orgid/$code/$filename";
								}
							}
							closedir($dh);
						}
					}
					
					
						$doc[] = $res1;
				}else{
					$res1 = array();
					$docid=$res1['id'] = $rowdoc->Id;
					$res1['name'] = $rowdoc->DocumentTypeId;
					$res1['desig'] = Utils::decode5t($rowdoc->DocumentNumber);
					$res1['fdate'] =Utils::dateformatter($rowdoc->IssuedOn);
					$res1['tdate'] = Utils::dateformatter($rowdoc->ExpiredOn);
					$res1['desc'] = "";
					$res1['originaldoc'] = (int)$rowdoc->OriginalDocSts;
					$res1['doctype'] = (int)$rowdoc->DocType;
					if($rowdoc->IssuedOn =="0000-00-00" ){
					$res1['fdate'] ="";
					}
					if($rowdoc->ExpiredOn =="0000-00-00" ){
					$res1['tdate'] ="";
					}
					
					$code= $this->getCode($rowdoc->EmployeeId);
					$doc1="$code".'_'."$docid";
					$dir="public/uploads/$orgid/$code";
					$filename="";
					if (is_dir($dir)) {
						if ($dh = opendir($dir)) {
							while (($file = readdir($dh)) != false) {
								$filename=$file;
								$ext = pathinfo($filename, PATHINFO_EXTENSION);
								if($filename=="$doc1.$ext")
								{
									$res1['empdoc']=URL."public/uploads/$orgid/$code/$filename";
								}
							}
							closedir($dh);
						}
					}
					
					
						$companydoc[] = $res1;
				}
				}
				
				$sqldoc = "SELECT * FROM EmployeeDependant WHERE EmployeeId = :id";
				$querydoc = $this->db->prepare($sqldoc);
				$querydoc->execute(array(':id' => $id ));
				while($rowdoc = $querydoc->fetch())
				{
					$res1 = array();
					$res1['id'] = $rowdoc->Id;
					$res1['relate'] = $rowdoc->EmployeeRelationId;
					$res1['fname'] = $rowdoc->FirstName;
					$res1['lname'] = $rowdoc->LastName;
					//$res1['bdate'] = Utils::dateformatter($rowdoc->DOB);
					$res1['nominee'] = (float)$rowdoc->NomineePercent;
					$res1['contact'] = (int)Utils::decode5t($rowdoc->Contact);
					
					
					$depen[] = $res1;
				}
				
				$sqlskill = "SELECT * FROM EmployeeSkills WHERE EmployeeId = :id";
				$queryskill = $this->db->prepare($sqlskill);
				$queryskill->execute(array(':id' => $id ));
				while($rowskill = $queryskill->fetch())
				{
					$res1 = array();
					$res1['id'] = $rowskill->Id;
					(int)$res1['skill'] = $rowskill->SkillsId;
					$res1['desc'] = $rowskill->Description;
					
					$skill[] = $res1;
				}
				
				$sqlcreditcard = "SELECT * FROM EmployeeCreditCard WHERE EmployeeId = :id";
				$querycreditcard = $this->db->prepare($sqlcreditcard);
				$querycreditcard->execute(array(':id' => $id ));
				while($rowcreditcard = $querycreditcard->fetch())
				{
					$res1 = array();
					$res1['id'] = $rowcreditcard->Id;
					$res1['creditcardid'] = $rowcreditcard->CreditCardId;
					$res1['bankid'] = $rowcreditcard->BankId;
					$res1['creditcard_no'] = Utils::decode5t($rowcreditcard->CreditCardNo);
					$res1['credit_issuedate'] =Utils::dateformatter($rowcreditcard->IssueDate) ;
					$res1['credit_validdate'] =Utils::dateformatter($rowcreditcard->ValidTill) ;
					$res1['credit_limit'] = $rowcreditcard->CreditCardLimit;
					
					if($rowcreditcard->IssueDate =="0000-00-00" ){
					$res1['credit_issuedate'] ="";
					}
					if($rowcreditcard->ValidTill =="0000-00-00" ){
					$res1['credit_validdate'] ="";
					}
					
					$creditcard[] = $res1;
				}
				
				$sqlinsurance = "SELECT * FROM EmployeeInsuranceDetails WHERE EmployeeId = :id";
				$queryinsurance = $this->db->prepare($sqlinsurance);
				$queryinsurance->execute(array(':id' => $id ));
				while($rowinsurance = $queryinsurance->fetch())
				{
					$res1 = array();
					$res1['id'] = $rowinsurance->Id;
					$res1['insuranceid'] = $rowinsurance->InsuranceId;
					$res1['insurance_period'] = $rowinsurance->InsurancePeriod;
					$res1['insured_amt'] = $rowinsurance->InsuredAmount;
					$res1['premium_amt'] = $rowinsurance->PremiumAmount;
					$res1['insurance_validdate'] =Utils::dateformatter($rowinsurance->ValidTill);
					if($rowinsurance->ValidTill =="0000-00-00" ){
					$res1['insurance_validdate'] ="";
					}
					$res1['insurance_nominee'] = $rowinsurance->NomineeDetails;
					
					
					$insurance[] = $res1;
				}
				
				$sqlbank= "SELECT * FROM EmployeeBankDetails WHERE EmployeeId = :id";
				$querybank= $this->db->prepare($sqlbank);
				$querybank->execute(array(':id' => $id ));
				while($rowbank= $querybank->fetch())
				{
					$res1 = array();
					$res1['id'] = $rowbank->Id;
					$res1['bankid'] = $rowbank->BankId;
					$res1['iban_no'] = Utils::decode5t($rowbank->IBAN);
					$res1['swiftcode'] = Utils::decode5t($rowbank->SwiftCode);
					$res1['branch'] = Utils::decode5t($rowbank->Branch);
					$res1['status'] = $rowbank->BankStatus;
					$res1['agent_id'] = $rowbank->agent_id;
					//if($rowbank->agent_id == null)
						//$res1['agent_id'] = Utils::getName($rowbank->BankId,'BankMaster','agent_id',$this->db);
					
					$bank[] = $res1;
				}
				
				$sqlbankloan= "SELECT * FROM EmployeeBankLoan WHERE EmployeeId = :id";
				$querybankloan= $this->db->prepare($sqlbankloan);
				$querybankloan->execute(array(':id' => $id ));
				while($rowbankloan= $querybankloan->fetch())
				{
					$res1 = array();
					$res1['id'] = $rowbankloan->Id;
					$res1['bankid'] = $rowbankloan->BankId;
					$res1['loan_amt'] = Utils::decode5t($rowbankloan->LoanAmount);
					$res1['tenure'] = Utils::decode5t($rowbankloan->Tenure);
					$res1['emi'] = Utils::decode5t($rowbankloan->EMI);
					$bankloan[] = $res1;
				}
				$sqllta= "SELECT * FROM EmployeeLTADetail WHERE EmployeeId = :id";
				$querylta= $this->db->prepare($sqllta);
				$querylta->execute(array(':id' => $id ));
				while($rowlta= $querylta->fetch())
				{
					$code= $this->getCode($rowlta->EmployeeId);
					$res1 = array();
					$res1['id'] = $rowlta->Id;
					$res1['fname'] = $rowlta->Name;
					$res1['bdate'] = Utils::dateformatter($rowlta->DOB);
					$res1['bdate1'] = $rowlta->DOB;
					$from=date_create(date($rowlta->DOB));
					$to=date_create(date('Y-m-d'));
					$diff=date_diff($to,$from);
					$age = $diff->format("%Y.%M");
					$res1['age'] = $age;
					$res1['passportno'] = Utils::decode5t($rowlta->PassportNo);
					$res1['emiratesid'] = Utils::decode5t($rowlta->EmiratesId);
					$res1['relate'] = $rowlta->Relation;
					$pa=$rowlta->PassportAttachment;
					if($pa!=""){
						$res1['passportcopy'] = URL."public/uploads/$orgid/$code/$pa";
					}
					$va=$rowlta->VisaAttachment;
					if($va!=""){
						$res1['visacopy'] = URL."public/uploads/$orgid/$code/$va";
					}
					
					$ltadetails[] = $res1;
				}
				$gradebenefit="";
				$sqlgrade = "SELECT * FROM GradeMaster WHERE Id = ? AND OrganizationId =?";
				$querygrade = $this->db->prepare($sqlgrade);
				$querygrade->execute(array($grade, $orgid ));
				while($rowgrade = $querygrade->fetch())
				{
					$gradebenefit=$rowgrade->Description;
				}
				
				$res['empwork'] = $work;
				$res['empqual'] = $qual;
				$res['empdocarray'] = $doc;
				$res['companydocarray'] = $companydoc;
				$res['empdepenarray'] = $depen;
				$res['empskills'] = $skill;
				$res['empcreditcard'] = $creditcard;
				$res['empinsurance'] = $insurance;
				$res['empbank'] = $bank;
				$res['empbankloan'] = $bankloan;
				$res['gradebenefit'] = $gradebenefit;
				$res['ltadetails'] = $ltadetails;
				$res['checklistarr'] = $checklistarr;
				$res['referencearr'] = $referencearr;
				
				$data[] = $res;
				
			}
        }
		
		if ($count == 1) {
           $status =true;
		   $successMsg = EMPLOYEE_MODULE_GETDETAIL_SUCCESS;
        } else {
           $status =false;
		   $errorMsg = EMPLOYEE_MODULE_GETDETAIL_FAILED;
        }
		
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
	
	
	public function updateConfirmDetail($arr)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$orgid = $_SESSION['ubihrm_org_id'];
		$mid = $arr[0];
		$mdate = date("Y-m-d H:i:s");
		$id = Utils::decode5t($arr[2]);
		$empsts="";
		if($arr[3]==1){
			$empsts="On Job";
		}else{
			$empsts="Terminated";
		}
		$confirmdate = $arr[4];
		
        $sql = "SELECT Id FROM EmploymentStatusMaster WHERE Name = '$empsts' and OrganizationId=? ";
        $query = $this->db->prepare($sql);
		$query->execute(array( $orgid ));
		$row = $query->fetch();
		$empsts = $row->Id;
		
		if($arr[3]==1){
		$sql = "update EmployeeMaster set DOC=date_add(DOJ, Interval ProvisionPeriod Month), EmployeeStatus=?, LastModifiedById=?, LastModifiedDate=? where Id=? and OrganizationId=?";
		$query = $this->db->prepare($sql);
		$query->execute(array( $empsts, $mid, $mdate, $id, $orgid ));
		}else{
		$sql = "update EmployeeMaster set DOL=date_add(DOJ, Interval ProvisionPeriod Month), EmployeeStatus=?, LastModifiedById=?, LastModifiedDate=? where Id=? and OrganizationId=?";
		$query = $this->db->prepare($sql);
		$query->execute(array( $empsts, $mid, $mdate, $id, $orgid ));
		
		
		
		$sql = "INSERT INTO SeveranceMaster(EmployeeId, EffectDate, SeveranceDate, Message, CreatedById, CreatedDate, LastModifiedById, LastModifiedDate, OrganizationId, OwnerId, SeveranceStatus, EmployeeStatus) VALUE(?,?,?,?,?,?,?,?,?,?,?,?)";
		$query = $this->db->prepare($sql);
		$query->execute(array( $id, $confirmdate, $confirmdate, "",  $mid, $mdate,  $mid, $mdate, $orgid, $mid, 3, 2 ));
		}
		$empname = Utils::getEmployeeName($id, $this->db);
		$name = Utils::getEmployeeName($mid, $this->db);
		 $title=""; $msg="";	
		////////create employee history/////////
		if($arr[3]==1){
			$title="Confirmation";
			$msg = "Your services are confirmed with effect from  ".date("d F, Y", strtotime($confirmdate));
		}else{
			$title="Termination";
			$msg = "You have completed your probation period and now you are terminated by '$name' ";	
		}		
	   	$sql="insert into EmployeeHistory ( EmployeeId, Title, EventDate, Message, OrganizationId) values(?,?,?,?,?)";
		$query = $this->db->prepare($sql);
		$query->execute(array($id, $title, $confirmdate, $msg, $orgid));
			   
			   
		
		
		$title ="End of probation period";
		$msg ="";
		if($arr[3]==1){
			$msg = $empname." have completed his probation period and now he is a confirmed employee   ";	
		}else{
			$msg = $empname." have completed his probation period and now he is terminated by '$name'  ";	
		}
			   
			   $sql="insert into NotificationMaster ( Name, Message, EmployeeIds, OrganizationId, CreatedDate, CreatedById, LastModifiedDate, LastModifiedById, OwnerId, StartDate, EndDate, NotificationType, NotificationPriority) values(?,?,?,?,?,?,?,?,?,?,?,?,?)";
			   $query = $this->db->prepare($sql);
			   $query->execute(array($title, $msg, "0", $orgid, $mdate, $mid, $mdate, $mid, $mid, date("Y-m-d"), date("Y-m-d", strtotime(date("Y-m-d").", +10 days ")), 1, 2));
		
		$result["data"] =$data;
		$result['status']=true;
		$result['successMsg']="Successfully updated record!";
		$result['errorMsg']=$errorMsg;
		
		return $result;
	}	
	
    /**
     * Setter for a EmployeeMaster (update)
     * @param array $request contains 5 parameter value that will be created
     * @return array feedback 
     */
    public function Update($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        
		$mdate = date("Y-m-d H:i:s");
		
		
		$arr = array();
		
		$arr[0] = $_POST['emp_fname'];
		$arr[1] = $_POST['emp_lname'];
		$arr[2] = Utils::getDateformat( $_POST['emp_dob']);
		$arr[3] = $_POST['emp_nationality'];
		$arr[4] = $_POST['emp_marital'];
		$arr[5] = $_POST['emp_religion'];
		$arr[6] = $_POST['emp_blood_group'];
		$arr[7] = is_array($_POST['emp_known_lang']) ? implode(',',$_POST['emp_known_lang']): $_POST['emp_known_lang'];
		$arr[8] = Utils::getDateformat( $_POST['emp_doj']);
		$arr[9] = Utils::getDateformat( $_POST['emp_doc']);
		$arr[10] = $_POST['emp_visa_type'];
		$arr[11] = $_POST['emp_gender'];
		$arr[12] = Utils::encode5t($_POST['emp_contact1']);
		$arr[13] = Utils::encode5t($_POST['emp_email1']);
		$arr[14] = Utils::encode5t($_POST['emp_address1']);
		$arr[15] = $_POST['emp_city1'];
		$arr[16] = $_POST['emp_country1'];
		$arr[17] = $_POST['emp_zipcode1'];
		$arr[18] = Utils::encode5t($_POST['emp_contact2']);
		$arr[19] = Utils::encode5t($_POST['emp_email2']);
		$arr[20] = Utils::encode5t($_POST['emp_address2']);
		$arr[21] = $_POST['emp_country2'];
		$arr[22] = $_POST['emp_city2'];
		$arr[23] = $_POST['emp_zipcode2'];
		$arr[24] = Utils::encode5t($_POST['emp_contact3']);
		$arr[25] = Utils::encode5t($_POST['emp_email3']);
		$arr[26] = Utils::encode5t($_POST['emp_address3']);
		$arr[27] = $_POST['emp_country3'];
		$arr[28] = $_POST['emp_city3'];
		$arr[29] = $_POST['emp_zipcode3'];
		$arr[30] = $_POST['emp_report_to'];
		$arr[31] = $_POST['emp_division'];
		$arr[32] = $_POST['emp_depart'];
		
		$desig=$arr[33] = $_POST['emp_desig'];
		$arr[34] = $_POST['emp_location'];
		$arr[35] = $_POST['emp_shift'];
		$arr[36] = $_POST['emp_sts'];
		$arr[37] = $_POST['emp_grade'];
		$arr[38] = $_POST['emp_workdays'];
		$arr[39] = $_POST['emp_functional'];
		$arr[40] = $_POST['salaryctc'];
		$arr[41] = $_POST['paypattern'];
		$arr[42] = $_POST['bankname'];
		$arr[43] = Utils::encode5t($_POST['bankifsccode']);
		$arr[44] = $_POST['salarytype'];
		$arr[45] = Utils::encode5t($_POST['bankaddress']);
		$arr[46] = $_POST['emp_type'];
		$arr[49] = $_POST['emp_experience'];
		$cmp_email=$arr[50] = Utils::encode5t(strtolower($_POST['cmp_email']));
		$arr[51] = $_POST['airticket'];
		$arr[52] = $_POST['ticketclass'];
		$arr[53] = $_POST['oncein'];
		$arr[54] = $_POST['nearestairport'];
		$arr[55] = $_POST['iatafare'];
		$arr[56] = $_POST['ticketamt'];
		$arr[57] = $_POST['instructions'];
		$arr[58] = $_POST['provision'];
		$arr[59] = $_POST['familydetails'];
		$arr[60] = $_POST['emp_mname'];
		$arr[61] = Utils::encode5t($_POST['personal_no']);
		$arr[62] = $_POST['overtimepay'];
		$arr[63] = $_POST['emp_code'];
		$arr[64] = $_POST['emp_channel'];
		$arr[65] = $_POST['emp_costcentre'];
		
		
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$empid =0;		
				$arr[47]=$mdate;
				$arr[48]=$mid;				
				$arr[66]=$_POST['emp_id'];
				$empid=$_POST['emp_id'];
				
		$this->db->beginTransaction();
		try
		{
			$sqlcode="SELECT * FROM EmployeeMaster WHERE EmployeeCode = :id and OrganizationId=:orgid and Id <> :eid";
			$querycode=$this->db->prepare($sqlcode);
			$querycode->execute(array(':id'=> $_POST['emp_code'], ':orgid'=> $orgid,  ':eid'=> $empid));
			$count1=$querycode->rowCount();;
			if($count1>=1){
				$status =false;
			    $errorMsg = "Employee with same code is already exist";
				$result["data"] =$data;
				$result['status']=$status;
				$result['successMsg']=$successMsg;
				$result['errorMsg']=$errorMsg;
				
				// default return
				return $result;
			}
			
		
			$sql = "UPDATE EmployeeMaster SET FirstName=?, LastName=?, DOB=?, Nationality=?, MaritalStatus=?, Religion=?, BloodGroup=?, KnownLanguage=?, DOJ=?, DOC=?, Visa=?, Gender=?, CurrentContactNumber=?, CurrentEmailId=?, CurrentAddress=?,CurrentCity=?, CurrentCountry=?,  CurrentZipCode=?, HomeContactNumber=?, HomeEmailId=?, HomeAddress=?, HomeCountry=?, HomeCity=?, HomeZipCode=?, EmergencyContactNumber=?, EmergencyEmailId=?, EmergencyAddress=?, EmergencyCountry=?, EmergencyCity=?, EmergencyZipCode=?, ReportingTo=?, Division=?, Department=?, Designation=?, Location=?, Shift=?, EmployeeStatus=?, Grade=?, WorkingDays=?, FunctionalArea=?, EmployeeCTC=?, PayPattern=?, BankName=?, BankIFSCCode=?, BankAccount=?, BankAddress=?,EmploymentType=?, LastModifiedDate=?, LastModifiedById=?, TotalExp=?, CompanyEmail=?,  AirTicket=?, TicketClass=?, OnceIn=?, NearestAirport=?, IATAFare=?, LastTicketAmt=?, TravelInstruction=?,ProvisionPeriod=?,FamilyDetail=?,MiddleName=?,PersonalNo=? ,OvertimePayment=?,EmployeeCode=? ,Channel=?, CostCentre=? where Id=?";
			
			$query = $this->db->prepare($sql);
			$query->execute($arr);
			
			// INSERTING AND UPDATING WORK EXPERIENCE RECORD OF EMPLOYEE IF PASSED AS AN JSON
			$work = json_decode($_POST['emp_workarray'], true); 
			$workid="0";
			for($i=0; $i<count($work); $i++){
				$workid .= ",".$work[$i]['id'];
			}
			$sqlwork = " DELETE FROM EmployeeWorkExperience WHERE EmployeeId=? AND Id NOT IN ($workid)";
			$querywork = $this->db->prepare($sqlwork);
			$querywork->execute(array( $empid));
			
			for($i=0; $i<count($work); $i++)
			{
				if($work[$i]['name']!=""){
					$record = array();
					$record[0] = $empid;
					$record[1] = $work[$i]['name'];
					$record[2] = $work[$i]['desig'];
					$fdate=$record[3] = Utils::getDateformat($work[$i]['fdate']);
					$tdate=$record[4] = Utils::getDateformat($work[$i]['tdate']);
					$record[5] = $work[$i]['desc'];
					$record[6] = $mdate;
					$record[7] = $mid;
					$record[8] = $mdate;
					$record[9] = $mid;
					$record[10] = $mid;
					$record[11] = $orgid;
					$id = $work[$i]['id'];
					
					if($id){
						$sqlwork = " UPDATE EmployeeWorkExperience SET CompanyName=?, Designation=?, FromDate=?, ToDate=?, Description=?, LastModifiedDate=?, LastModifiedById=? ,OrganizationId= ? where Id=?";
						$querywork = $this->db->prepare($sqlwork);
						$querywork->execute(array($work[$i]['name'],$work[$i]['desig'],$fdate,$tdate,$work[$i]['desc'],$mdate,$mid,$orgid,  $id));
					}else{
						$sqlwork = " INSERT INTO EmployeeWorkExperience (EmployeeId, CompanyName, Designation, FromDate, ToDate, Description, CreatedDate, CreatedById, LastModifiedDate, LastModifiedById, OwnerId, OrganizationId) values (?,?,?,?,?,?,?,?,?,?,?,?)";
						$querywork = $this->db->prepare($sqlwork);
						$querywork->execute($record);
					}
					
				}
			}
			///refrence
			  $ref = json_decode($_POST['referencearray'], true); 
			for($i=0; $i<count($ref); $i++)
			{
				if($ref[$i]['name']!=""){
					$record = array();
				    $record[0] = $empid;
					//$record[1] = $ref[$i]['id'];
					$record[1] = $ref[$i]['name'];
					$record[2] = $ref[$i]['company'];
					$record[3] =Utils::encode5t($ref[$i]['email']);
				    $record[4] =Utils::encode5t($ref[$i]['contact']);
				    $id = $ref[$i]['id'];
					
				   if($id){
						$sqlwork = " UPDATE EmployeeReference SET Name=?,Company=?,Email=?, Contact=? WHERE Id=?";
						$querywork = $this->db->prepare($sqlwork);
						$querywork->execute(array($ref[$i]['name'], $ref[$i]['company'], Utils::encode5t($ref[$i]['email']), Utils::encode5t($ref[$i]['contact']),$id));
					}
					else{
					$sqlref = " INSERT INTO EmployeeReference (EmployeeId,Name, Company, Email, Contact) values (?,?,?,?,?)";
					$queryref = $this->db->prepare($sqlref);
					$queryref->execute($record);
				}
				}
				
			}
			
			
			
			
			// INSERTING AND UPDATING SALARY RECORD OF EMPLOYEE IF PASSED AS AN JSON
			
			$lastsalaryupdatedate=$this->getLastSalaryHistoryUpdated($empid);
			$work = json_decode($_POST['emp_salarydetails'], true); 
			$temp=0;
			for($i=0; $i<count($work); $i++)
			{
				if($work[$i]['name']!=""){
					$record = array();
					$record[0] = $empid;
					$record[1] = $work[$i]['id'];
					$record[2] = $work[$i]['headtype'];
					$record[3] = $work[$i]['amount'];
					$record[4] = $orgid;
					
					$sqlsalary ="select * from EmployeeSalaryDetails where HeadId=? and EmployeeId=? and OrganizationId=?";
					$querysalary = $this->db->prepare($sqlsalary);
					$querysalary->execute(array($work[$i]['id'],$empid,$orgid));
					if($querysalary->rowCount()>0){
						
						$sqlwork = " UPDATE EmployeeSalaryDetails SET HeadAmount=?,HeadType=? Where HeadId=? and EmployeeId=? and OrganizationId=?";
						$querywork = $this->db->prepare($sqlwork);
						$querywork->execute(array($work[$i]['amount'],$work[$i]['headtype'], $work[$i]['id'],$empid,$orgid));
					}else{
						$sqlwork = " INSERT INTO EmployeeSalaryDetails (EmployeeId, HeadId, HeadType, HeadAmount, OrganizationId) values (?,?,?,?,?)";
						$querywork = $this->db->prepare($sqlwork);
						$querywork->execute($record);
					}
					
					////////////create salary history//////////
					/*$sqlsalary ="select * from SalaryHistory where HeadId=? and HeadAmount=? and EmployeeId=? and OrganizationId=? and CreatedDate = ? ";
					$querysalary = $this->db->prepare($sqlsalary);
					$querysalary->execute(array($work[$i]['id'],$work[$i]['amount'],$empid,$orgid,$lastsalaryupdatedate));
					if($querysalary->rowCount()==0){
						
						$temp++;
					}*/
					
				}
			}
			/*
			if($temp>0){
				for($i=0; $i<count($work); $i++)
				{
					if($work[$i]['name']!=""){
						$record = array();
						$record[0] = $empid;
						$record[1] = $work[$i]['id'];
						$record[2] = $work[$i]['headtype'];
						$record[3] = $work[$i]['amount'];
						$record[4] = $orgid;
						
						$sqlwork = " INSERT INTO SalaryHistory (EmployeeId, HeadId, HeadType, HeadAmount, OrganizationId,CreatedDate) values (?,?,?,?,?,?)";
						$querywork = $this->db->prepare($sqlwork);
						$querywork->execute(array($empid,$work[$i]['id'],$work[$i]['headtype'],$work[$i]['amount'],$orgid,$mdate));
						
					}
				}
			}*/
			// INSERTING AND UPDATING QUALIFICATION RECORD OF EMPLOYEE IF PASSED AS AN JSON
			$work = json_decode($_POST['emp_qualificationarray'], true);
			$workid="0";
			for($i=0; $i<count($work); $i++){
				$workid .= ",".$work[$i]['id'];
			}
			$sqlwork = " DELETE FROM EmployeeQualification WHERE EmployeeId=? AND Id NOT IN ($workid)";
			$querywork = $this->db->prepare($sqlwork);
			$querywork->execute(array( $empid));
			
			for($i=0; $i<count($work); $i++)
			{
				if($work[$i]['name']!=""){
					$record = array();
					$record[0] = $empid;
					$record[1] = $work[$i]['name'];
					$record[2] = $work[$i]['desig'];
					$record[3] = $work[$i]['fdate'];
					$tdate=$record[4] = Utils::getDateformat($work[$i]['tdate']);
					$record[5] = $work[$i]['desc'];
					$record[6] = $mdate;
					$record[7] = $mid;
					$record[8] = $mdate;
					$record[9] = $mid;
					$record[10] = $mid;
					$record[11] = $orgid;
					$id = $work[$i]['id'];
					if($id){
						$sqlwork = " UPDATE EmployeeQualification SET InstituteName=?, Degree=?, FOS=?, DOC=?, GPA=?, LastModifiedDate=?, LastModifiedById=?,OrganizationId=?  WHERE Id=?";
						$querywork = $this->db->prepare($sqlwork);
						$querywork->execute(array($work[$i]['name'],$work[$i]['desig'],$work[$i]['fdate'],$tdate,$work[$i]['desc'],$mdate,$mid,$orgid,  $id));
					}else{
						$sqlwork = " INSERT INTO EmployeeQualification (EmployeeId, InstituteName, Degree, FOS, DOC, GPA, CreatedDate, CreatedById, LastModifiedDate, LastModifiedById, OwnerId, OrganizationId) values (?,?,?,?,?,?,?,?,?,?,?,?)";
						$querywork = $this->db->prepare($sqlwork);
						$querywork->execute($record);
					}
				}
			}
			
			// INSERTING AND UPDATING DOCUMENT RECORD OF EMPLOYEE IF PASSED AS AN JSON
			$work = json_decode($_POST['emp_documentarray'], true); 
			$workid="0";
			for($i=0; $i<count($work); $i++){
				$workid .= ",".$work[$i]['id'];
			}
			$sqlwork = " DELETE FROM EmployeeDocument WHERE EmployeeId=? AND Id NOT IN ($workid)";
			$querywork = $this->db->prepare($sqlwork);
			$querywork->execute(array( $empid));
			
			for($i=0; $i<count($work); $i++)
			{
				if($work[$i]['name']!=""){
					$docsts=isset($work[$i]['originaldoc'])?$work[$i]['originaldoc']:0;
					$doctype=isset($work[$i]['doctype'])?$work[$i]['doctype']:0;
					$record = array();
					$record[0] = $empid;
					$record[1] = $work[$i]['name'];
					$record[2] = Utils::encode5t($work[$i]['desig']);
					$fdate=$record[3] = Utils::getDateformat($work[$i]['fdate']);
					$tdate=$record[4] = Utils::getDateformat($work[$i]['tdate']);
					//$record[5] = $work[$i]['desc'];
					$record[5] = $mdate;
					$record[6] = $mid;
					$record[7] = $mdate;
					$record[8] = $mid;
					$record[9] = $mid;
					$record[10] = $orgid;
					$record[11] = $docsts;
					$record[12] = $doctype;					
					$id = $work[$i]['id'];
					if($id){
						$sqlwork = " UPDATE EmployeeDocument SET DocumentTypeId=?, DocumentNumber=?, IssuedOn=?, ExpiredOn=?, LastModifiedDate=?, LastModifiedById=?, OriginalDocSts=?, DocType=? WHERE Id=?";
						$querywork = $this->db->prepare($sqlwork);
						$querywork->execute(array($work[$i]['name'], Utils::encode5t($work[$i]['desig']), $fdate,$tdate, $mdate, $mid,$docsts, $doctype, $id));
					}else{
						$sqlwork = " INSERT INTO EmployeeDocument (EmployeeId, DocumentTypeId, DocumentNumber, IssuedOn, ExpiredOn, CreatedDate, CreatedById, LastModifiedDate, LastModifiedById, OwnerId, OrganizationId,OriginalDocSts,DocType) values (?,?,?,?,?,?,?,?,?,?,?,?,?)";
						$querywork = $this->db->prepare($sqlwork);
						$querywork->execute($record);
					}
				}
			}
			
			// INSERTING AND UPDATING DEPENDANT RECORD OF EMPLOYEE IF PASSED AS AN JSON
			$dependant = json_decode($_POST['emp_dependant'], true); 
			$depenid="0";
			for($i=0; $i<count($dependant); $i++){
				$depenid .= ",".$dependant[$i]['id'];
			}
			$sqlwork = " DELETE FROM EmployeeDependant WHERE EmployeeId=? AND Id NOT IN ($depenid)";
			$querywork = $this->db->prepare($sqlwork);
			$querywork->execute(array( $empid));
			
			for($i=0; $i<count($dependant); $i++)
			{
				if($dependant[$i]['relate']!="" && $dependant[$i]['fname']!=""){
					$record = array();
					$record[0] = $empid;
					$record[1] = $dependant[$i]['relate'];
					$record[2] = $dependant[$i]['fname'];
					$record[3] = $dependant[$i]['lname'];
					//$bdate=$record[4] = Utils::getDateformat($dependant[$i]['bdate']);
					$record[4] = $dependant[$i]['nominee'];
					$record[5] = Utils::encode5t($dependant[$i]['contact']);
					
					
					$id = $dependant[$i]['id'];
					if($id){
						$sqlwork = " UPDATE EmployeeDependant SET EmployeeRelationId=?, FirstName=?, LastName=?,  NomineePercent=?,Contact=? WHERE Id=?";
						$querywork = $this->db->prepare($sqlwork);
						$querywork->execute(array($dependant[$i]['relate'], $dependant[$i]['fname'], $dependant[$i]['lname'],  $dependant[$i]['nominee'],$record[5],  $id));
					}else{
						$sqlwork = " INSERT INTO EmployeeDependant (EmployeeId, EmployeeRelationId, FirstName, LastName,  NomineePercent,Contact) values (?,?,?,?,?,?)";
						$querywork = $this->db->prepare($sqlwork);
						$querywork->execute($record);
					}
				}
			}
			// INSERTING SKILLS OF EMPLOYEE IF PASSED AS AN JSON
			$skill = json_decode($_POST['emp_skill'], true); 
			$skillid="0";
			for($i=0; $i<count($skill); $i++){
				$skillid .= ",".$skill[$i]['id'];
			}
			$sqlwork = " DELETE FROM EmployeeSkills WHERE EmployeeId=? AND Id NOT IN ($skillid)";
			$querywork = $this->db->prepare($sqlwork);
			$querywork->execute(array( $empid));
			for($i=0; $i<count($skill); $i++)
			{
				if($skill[$i]['skill']!=""){
					$record = array();
					$record[0] = $empid;
					$record[1] = $skill[$i]['skill'];
					$record[2] = $skill[$i]['desc'];
					
					$id = $skill[$i]['id'];
					if($id){
						$sqlwork = " UPDATE EmployeeSkills SET EmployeeId=?, SkillsId=?, Description=? WHERE Id=?";
						$querywork = $this->db->prepare($sqlwork);
						$querywork->execute(array($empid,$skill[$i]['skill'], $skill[$i]['desc'],  $id));
					}else{
						$sqlwork = " INSERT INTO EmployeeSkills (EmployeeId, SkillsId,Description) values (?,?,?)";
						$querywork = $this->db->prepare($sqlwork);
						$querywork->execute($record);
					}
					
				}
			}
			
			//INSERTING CREDIT CARD DETAILS OF EMPLOYEE 
					$creditcard = json_decode($_POST['emp_creditcard'], true);
					$creditcardid="0";
					for($i=0; $i<count($creditcard); $i++){
						$creditcardid .= ",".$creditcard[$i]['id'];
					}
					$sqlwork = " DELETE FROM EmployeeCreditCard WHERE EmployeeId=? AND Id NOT IN ($creditcardid)";
					$querywork = $this->db->prepare($sqlwork);
					$querywork->execute(array( $empid));
					 
					for($i=0; $i<count($creditcard); $i++)
					{
						if($creditcard[$i]['creditcardid']!="" && $creditcard[$i]['bankid']!=""){
							$record = array();
							$record[0] = $empid;
							$record[1] = $creditcard[$i]['creditcardid'];
							$record[2] = $creditcard[$i]['bankid'];
							$record[3] = Utils::encode5t($creditcard[$i]['creditcard_no']);
							$fdate=$record[4] = Utils::getDateformat($creditcard[$i]['credit_issuedate']);
							$tdate=$record[5] = Utils::getDateformat($creditcard[$i]['credit_validdate']);
							$record[6] = $creditcard[$i]['credit_limit'];
							
							$id = $creditcard[$i]['id'];
							if($id){
								$sqlwork = " UPDATE EmployeeCreditCard SET EmployeeId=?, CreditCardId=?,  BankId=?,CreditCardNo=?, IssueDate=?, ValidTill=?, CreditCardLimit=?  WHERE Id=?";
								$querywork = $this->db->prepare($sqlwork);
								$querywork->execute(array($empid,$creditcard[$i]['creditcardid'],$creditcard[$i]['bankid'], Utils::encode5t($creditcard[$i]['creditcard_no']),$fdate,$tdate,$creditcard[$i]['credit_limit'],  $id));
							}else{
								$sqlwork = " INSERT INTO EmployeeCreditCard (EmployeeId, CreditCardId, BankId,CreditCardNo, IssueDate, ValidTill, CreditCardLimit) values (?,?,?,?,?,?,?)";
								$querywork = $this->db->prepare($sqlwork);
								$querywork->execute($record);
							}
							
						}
					}
					
					//INSERTING INSURANCE DETAILS OF EMPLOYEE 
					
					$insurance = json_decode($_POST['emp_insurance'], true); 
					
					$insuranceid="0";
					for($i=0; $i<count($insurance); $i++){
						$insuranceid .= ",".$insurance[$i]['id'];
					}
					$sqlwork = " DELETE FROM EmployeeInsuranceDetails WHERE EmployeeId=? AND Id NOT IN ($insuranceid)";
					$querywork = $this->db->prepare($sqlwork);
					$querywork->execute(array( $empid));
					for($i=0; $i<count($insurance); $i++)
					{
						if($insurance[$i]['insuranceid']!="" ){
							$record = array();
							$record[0] = $empid;
							$record[1] = $insurance[$i]['insuranceid'];
							$record[2] = $insurance[$i]['insurance_period'];
							$record[3] = $insurance[$i]['insured_amt'];
							$record[4] = $insurance[$i]['premium_amt'];
							$fdate=$record[5] = Utils::getDateformat($insurance[$i]['insurance_validdate']);
							$record[6] = $insurance[$i]['insurance_nominee'];
							$id = $insurance[$i]['id'];
							if($id){
								$sqlwork = " UPDATE EmployeeInsuranceDetails SET EmployeeId=?, InsuranceId=?,InsurancePeriod=?,InsuredAmount=?, PremiumAmount=?, ValidTill=?,  NomineeDetails=? WHERE Id=?";
								$querywork = $this->db->prepare($sqlwork);
								$querywork->execute(array($empid,$insurance[$i]['insuranceid'],$insurance[$i]['insurance_period'], $insurance[$i]['insured_amt'],$insurance[$i]['premium_amt'],$fdate, $insurance[$i]['insurance_nominee'],  $id));
							}else{
								$sqlwork = " INSERT INTO EmployeeInsuranceDetails ( EmployeeId, InsuranceId, InsurancePeriod,  InsuredAmount, PremiumAmount,  ValidTill, NomineeDetails) values (?,?,?,?,?,?,?)";
								$querywork = $this->db->prepare($sqlwork);
								$querywork->execute($record);
							}
							
							
						}
					}
					//INSERTING BANK DETAILS OF EMPLOYEE 
					
					$bank = json_decode($_POST['emp_bank'], true); 
					$agent_id="0";
					$bankid="0";
					for($i=0; $i<count($bank); $i++){
						$bankid .= ",".$bank[$i]['id'];
					}
					$sqlbank1 = " DELETE FROM EmployeeBankDetails WHERE EmployeeId=? AND Id NOT IN ($bankid)";
					$querybank1 = $this->db->prepare($sqlbank1);
					$querybank1->execute(array( $empid));
					for($i=0; $i<count($bank); $i++)
					{
						if($bank[$i]['bankid']!="" && $bank[$i]['iban_no']!=""){
							$record = array();
							$record[0] = $empid;
							$record[1] = $bank[$i]['bankid'];
							$record[2] = Utils::encode5t($bank[$i]['iban_no']);
							$record[3] = Utils::encode5t($bank[$i]['swiftcode']);
							$record[4] = Utils::encode5t($bank[$i]['branch']);
							$record[5] = $bank[$i]['status'];
							$record[6] = $bank[$i]['agent_id'];
							
							$id = $bank[$i]['id'];
							if($id){
								$sqlbank = " UPDATE EmployeeBankDetails SET EmployeeId=?, BankId=?, IBAN=?, SwiftCode=?, Branch=?,BankStatus=?, agent_id=? WHERE Id=?";
								$querybank = $this->db->prepare($sqlbank);
								$querybank->execute(array($empid, $bank[$i]['bankid'], $record[2], $record[3], $record[4] ,$bank[$i]['status'], $bank[$i]['agent_id'], $id));
							}
							
							else{	
								$sqlbank = " INSERT INTO EmployeeBankDetails ( EmployeeId, BankId, IBAN,  SwiftCode, Branch,BankStatus,	agent_id) values (?,?,?,?,?,?,?)";
								$querybank = $this->db->prepare($sqlbank);
								$querybank->execute($record);
								$countbank=$querybank->rowcount();
						}
							
							
						}
					}
					
					//INSERTING BANKLOAN DETAILS OF EMPLOYEE 
					
					$bankloan = json_decode($_POST['emp_bankloan'], true); 
					
					$bankloanid="0";
					for($i=0; $i<count($bankloan); $i++){
						$bankloanid .= ",".$bankloan[$i]['id'];
					}
					$sqlbankloan = " DELETE FROM EmployeeBankLoan WHERE EmployeeId=? AND Id NOT IN ($bankloanid)";
					$querybankloan = $this->db->prepare($sqlbankloan);
					$querybankloan->execute(array( $empid));
					for($i=0; $i<count($bankloan); $i++)
					{
						if($bankloan[$i]['bankid']!="" && $bankloan[$i]['loan_amt']!=""){
							$record = array();
							$record[0] = $empid;
							$record[1] = $bankloan[$i]['bankid'];
							$record[2] = Utils::encode5t($bankloan[$i]['loan_amt']);
							$record[3] = Utils::encode5t($bankloan[$i]['tenure']);
							$record[4] = Utils::encode5t($bankloan[$i]['emi']);
							$id = $bankloan[$i]['id'];
							if($id){
								$sqlbankloan = " UPDATE EmployeeBankLoan SET EmployeeId=?, BankId=?, LoanAmount=?, Tenure=?, EMI=? WHERE Id=?";
								$querybankloan = $this->db->prepare($sqlbankloan);
								$querybankloan->execute(array($empid, $bankloan[$i]['bankid'], $record[2], $record[3], $record[4] , $id));
							}else{
								$sqlbankloan = " INSERT INTO EmployeeBankLoan ( EmployeeId, BankId, LoanAmount,  Tenure, EMI) values (?,?,?,?,?)";
								$querybankloan = $this->db->prepare($sqlbankloan);
								$querybankloan->execute($record);
							}	
						}
					}
					
		
					// INSERTING AND UPDATING FamilyDetail OF EMPLOYEE IF PASSED AS AN JSON
			$ltadetails = json_decode($_POST['emp_ltadetails'], true); 
			$ltaid="0";
			for($i=0; $i<count($ltadetails); $i++){
				$ltaid .= ",".$ltadetails[$i]['id'];
			}
			$sqlwork = " DELETE FROM EmployeeLTADetail WHERE EmployeeId=? AND Id NOT IN ($ltaid)";
			$querywork = $this->db->prepare($sqlwork);
			$querywork->execute(array( $empid));
			
			for($i=0; $i<count($ltadetails); $i++)
			{
				if($ltadetails[$i]['fname']!="" && $ltadetails[$i]['bdate']!="" && $ltadetails[$i]['passportno']!="" && $ltadetails[$i]['emiratesid']!=""){
					$record = array();
					$record[0] = $empid;
					$record[1] = $ltadetails[$i]['fname'];
					$record[2] = Utils::getDateformat($ltadetails[$i]['bdate']);
					$record[3] = Utils::encode5t($ltadetails[$i]['passportno']);
					$record[4] = Utils::encode5t($ltadetails[$i]['emiratesid']);
					$record[5] = $ltadetails[$i]['relate'];
									
					$id = $ltadetails[$i]['id'];
					if($id){
						$sqlwork = " UPDATE EmployeeLTADetail SET Name=?, DOB=?, PassportNo=?,  EmiratesId=?,Relation=? WHERE Id=?";
						$querywork = $this->db->prepare($sqlwork);
						$querywork->execute(array($ltadetails[$i]['fname'], Utils::getDateformat($ltadetails[$i]['bdate']), $record[3],  $record[4],$ltadetails[$i]['relate'], $id));
					}else{
						$sqlwork = " INSERT INTO EmployeeLTADetail ( EmployeeId, Name, DOB, PassportNo, EmiratesId,Relation) values (?,?,?,?,?,?)";
						$querywork = $this->db->prepare($sqlwork);
						$querywork->execute($record);
					}
				}
			}
			
			$count =  $query->rowCount();		
			
			if ($count == 1) {
				
				
				$sql1 = "UPDATE  UserMaster SET Username = ?, RoleId = ?,   LastModifiedDate = ?, LastModifiedById = ?, username_mobile=? WHERE EmployeeId = ? ";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array(  $cmp_email, $desig, $mdate, $mid ,Utils::encode5t($_POST['emp_contact1']), $empid));
							
				$status =true;
				$successMsg = EMPLOYEE_MODULE_UPDATION_SUCCESS;
			} else {
			   $status =false;
			   $errorMsg = EMPLOYEE_MODULE_UPDATION_FAILED;
			}
			
		  $this->db->commit();     
		}catch(PDOException $e)
		{
		$status =false;
			$this->db->rollBack();
			$errorMsg = 'Message: ' .$e->getMessage();
		}catch(Exception $e)
		{
		$status =false;
			$this->db->rollBack();
			$errorMsg = 'Message: ' .$e->getMessage();
		}  
		
        
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }

	///////////////////////////////////////////////////////////////
   
    /**
     * Setter for a EmployeeMaster (create)
     * @param array $request contains 4 parameter that will be created
     * @return array feedback
     */
    public function Create($request)
    {
		$result = array();
		$count=0; $count1=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array(); $maxid=0;
        $empid =0;	
		$mdate = date("Y-m-d H:i:s");
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		//$maxemp=Utils::getName($orgid, 'Organization', 'NoOfEmp', $this->db);
		$availemp=Utils::getTotalEmp($orgid, $this->db);
		if($availemp){
		////////// generate employee code///////
		$sqldiv="SELECT Code FROM DivisionMaster WHERE Id =?";	
		$querydiv = $this->db->prepare($sqldiv);
		$querydiv->execute(array($_POST['emp_division']));
											
		while($rowdiv = $querydiv->fetch()){
			$divcode=$rowdiv->Code;
		}
		
		$doj=Utils::getDateformat($_POST['emp_doj']);					
		$yearofjoining=date("y", strtotime(date($doj)));
		$ecode=$divcode.$yearofjoining;	
		$employeecode=$this->CheckexistingEmpcode($ecode,$request[1]);
		$maxid=$this->getMaxEmpid($orgid);
		$employeecode="E".$maxid;
		$employeecode=($_POST['emp_code']=="")?$employeecode:$_POST['emp_code'];
		
		$arr = array();
		$arr[0] = "";
		$arr[1] = $employeecode;
		$arr[2] = $_POST['emp_fname'];
		$arr[3] = $_POST['emp_lname'];
		$arr[4] = Utils::getDateformat($_POST['emp_dob']);
		$arr[5] = $_POST['emp_nationality'];
		$arr[6] = $_POST['emp_marital'];
		$arr[7] = $_POST['emp_religion'];
		$arr[8] = $_POST['emp_blood_group'];
		$arr[9] = is_array($_POST['emp_known_lang']) ? implode(',',$_POST['emp_known_lang']): $_POST['emp_known_lang'];
		$arr[10] = Utils::getDateformat($_POST['emp_doj']);
		$arr[11] = Utils::getDateformat($_POST['emp_doc']);
		$arr[12] = $_POST['emp_visa_type'];
		$arr[13] = $_POST['emp_gender'];
		$arr[14] = Utils::encode5t($_POST['emp_contact1']);
		$arr[15] = Utils::encode5t($_POST['emp_email1']);
		$arr[16] = Utils::encode5t($_POST['emp_address1']);
		$arr[17] = $_POST['emp_city1'];
		$arr[18] = $_POST['emp_country1'];
		$arr[19] = $_POST['emp_zipcode1'];
		$arr[20] = Utils::encode5t($_POST['emp_contact2']);
		$arr[21] = Utils::encode5t($_POST['emp_email2']);
		$arr[22] = Utils::encode5t($_POST['emp_address2']);
		$arr[23] = $_POST['emp_country2'];
		$arr[24] = $_POST['emp_city2'];
		$arr[25] = $_POST['emp_zipcode2'];
		$arr[26] = Utils::encode5t($_POST['emp_contact3']);
		$arr[27] = Utils::encode5t($_POST['emp_email3']);
		$arr[28] = Utils::encode5t($_POST['emp_address3']);
		$arr[29] = $_POST['emp_country3'];
		$arr[30] = $_POST['emp_city3'];
		$arr[31] = $_POST['emp_zipcode3'];
		$arr[32] = $_POST['emp_report_to'];
		$arr[33] = $_POST['emp_division'];
		$arr[34] = $_POST['emp_depart'];
		$desig=$arr[35] = $_POST['emp_desig'];
		$arr[36] = $_POST['emp_location'];
		$arr[37] = $_POST['emp_shift'];
		$arr[38] = $_POST['emp_sts'];
		$arr[39] = $_POST['emp_grade'];
		$arr[40] = $_POST['emp_workdays'];
		$arr[41] = $_POST['emp_functional'];
		$arr[42] = $_POST['salaryctc'];
		$arr[43] = $_POST['paypattern'];
		$arr[44] = $_POST['bankname'];
		$arr[45] = Utils::encode5t($_POST['bankifsccode']);
		$arr[46] = $_POST['salarytype'];
		$arr[47] = Utils::encode5t($_POST['bankaddress']);
		$arr[48] = $_POST['emp_type'];
		$arr[55] = $_POST['emp_experience'];
		$cmp_email=$arr[56] = Utils::encode5t($_POST['cmp_email']);
		
		$arr[57] = $_POST['airticket'];
		$arr[58] = $_POST['ticketclass'];
		$arr[59] = $_POST['oncein'];
		$arr[60] = $_POST['nearestairport'];
		$arr[61] = $_POST['iatafare'];
		$arr[62] = $_POST['ticketamt'];
		$arr[63] = $_POST['instructions'];
		$arr[64] = $_POST['provision'];
		$arr[65] = $_POST['familydetails'];
		$arr[66] = $_POST['emp_mname'];
		$arr[67] = Utils::encode5t($_POST['personal_no']);
		$arr[68] = $_POST['overtimepay'];
		$arr[69] = $_POST['emp_channel'];
		$arr[70] = $_POST['emp_costcentre'];
		$empid =0;		
		$arr[49]=$orgid;
		$arr[50]=$mdate;
		$arr[51]=$mid;
		$arr[52]=$mdate;
		$arr[53]=$mid;
		$arr[54]=$mid;
				
		$this->db->beginTransaction();
		try
		{
			$sqlcode="SELECT * FROM EmployeeMaster WHERE EmployeeCode = :id and OrganizationId=:orgid";
			$querycode=$this->db->prepare($sqlcode);
			$querycode->execute(array(':id'=> $employeecode, ':orgid'=> $orgid));
			$count1=$querycode->rowCount();;
			if($count1>=1){
				$status =false;
			    $errorMsg = EMPLOYEE_MODULE_UPDATION_DUPLICATE;
			}
			else{
			$sql = "INSERT INTO EmployeeMaster (ImageName, EmployeeCode, FirstName, LastName, DOB, Nationality, MaritalStatus, Religion, BloodGroup, KnownLanguage, DOJ, DOC, Visa, Gender, CurrentContactNumber, CurrentEmailId, CurrentAddress,CurrentCity, CurrentCountry,  CurrentZipCode, HomeContactNumber, HomeEmailId, HomeAddress, HomeCountry, HomeCity, HomeZipCode, EmergencyContactNumber, EmergencyEmailId, EmergencyAddress, EmergencyCountry, EmergencyCity, EmergencyZipCode, ReportingTo, Division, Department, Designation, Location, Shift, EmployeeStatus, Grade, WorkingDays, FunctionalArea,EmployeeCTC, PayPattern, BankName, BankIFSCCode, BankAccount, BankAddress,EmploymentType, OrganizationId,  LastModifiedDate, LastModifiedById, CreatedDate, CreatedById, OwnerId, TotalExp, CompanyEmail,  AirTicket, TicketClass, OnceIn, NearestAirport, IATAFare, LastTicketAmt, TravelInstruction, ProvisionPeriod, FamilyDetail, MiddleName, PersonalNo, OvertimePayment,Channel,CostCentre) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?,?,?,?,?)";
			
			$query = $this->db->prepare($sql);
			$query->execute($arr);
			$empid=$this->db->lastInsertId();
			// INSERTING WORK EXPERIENCE RECORD OF EMPLOYEE IF PASSED AS AN JSON
			$work = json_decode($_POST['emp_workarray'], true); 
			for($i=0; $i<count($work); $i++)
			{
				if($work[$i]['name']!=""){
					$record = array();
					$record[0] = $empid;
					$record[1] = $work[$i]['name'];
					$record[2] = $work[$i]['desig'];
					$record[3] =Utils::getDateformat( $work[$i]['fdate']);
					$record[4] = Utils::getDateformat($work[$i]['tdate']);
					$record[5] = $work[$i]['desc'];
					$record[6] = $mdate;
					$record[7] = $mid;
					$record[8] = $mdate;
					$record[9] = $mid;
					$record[10] = $mid;
					$record[11] = $orgid;
					
					$sqlwork = " INSERT INTO EmployeeWorkExperience (EmployeeId, CompanyName, Designation, FromDate, ToDate, Description, CreatedDate, CreatedById, LastModifiedDate, LastModifiedById, OwnerId, OrganizationId) values (?,?,?,?,?,?,?,?,?,?,?,?)";
					$querywork = $this->db->prepare($sqlwork);
					$querywork->execute($record);
				}
			}
			
			
			
			// INSERTING AND UPDATING SALARY RECORD OF EMPLOYEE IF PASSED AS AN JSON
			$work = json_decode($_POST['emp_salarydetails'], true); 
			for($i=0; $i<count($work); $i++)
			{
				if($work[$i]['name']!=""){
					$record = array();
					$record[0] = $empid;
					$record[1] = $work[$i]['id'];
					$record[2] = $work[$i]['headtype'];
					$record[3] = $work[$i]['amount'];
					$record[4] = $orgid;
					
					$sqlsalary ="select * from EmployeeSalaryDetails where HeadId=? and EmployeeId=? and OrganizationId=?";
					$querysalary = $this->db->prepare($sqlsalary);
					$querysalary->execute(array($work[$i]['id'],$empid,$orgid));
					if($querysalary->rowCount()>0){
						
						$sqlwork = " UPDATE EmployeeSalaryDetails SET HeadAmount=?,HeadType=? Where HeadId=? and EmployeeId=? and OrganizationId=?";
						$querywork = $this->db->prepare($sqlwork);
						$querywork->execute(array($work[$i]['amount'],$work[$i]['headtype'], $work[$i]['id'],$empid,$orgid));
					}else{
						$sqlwork = " INSERT INTO EmployeeSalaryDetails (EmployeeId, HeadId, HeadType, HeadAmount, OrganizationId) values (?,?,?,?,?)";
						$querywork = $this->db->prepare($sqlwork);
						$querywork->execute($record);
					}
					/////////create salary history/////////
					/*
					$sqlsalary ="select * from SalaryHistory where HeadId=? and EmployeeId=? and OrganizationId=? and Date(CreatedDate) = CURDATE() and HeadAmount=? ";
					$querysalary = $this->db->prepare($sqlsalary);
					$querysalary->execute(array($work[$i]['id'],$empid,$orgid,$work[$i]['amount']));
					if($querysalary->rowCount()>0){
						
						$sqlwork = " UPDATE SalaryHistory SET HeadAmount=?,HeadType=? Where HeadId=? and EmployeeId=? and OrganizationId=?";
						$querywork = $this->db->prepare($sqlwork);
						$querywork->execute(array($work[$i]['amount'],$work[$i]['headtype'], $work[$i]['id'],$empid,$orgid));
					}else{
						$sqlwork = " INSERT INTO SalaryHistory (EmployeeId, HeadId, HeadType, HeadAmount, OrganizationId,CreatedDate) values (?,?,?,?,?,?)";
						$querywork = $this->db->prepare($sqlwork);
						$querywork->execute(array($empid,$work[$i]['id'],$work[$i]['headtype'],$work[$i]['amount'],$orgid,$mdate));
					}
					*/
				}
			}
			
			// INSERTING QUALIFICATION RECORD OF EMPLOYEE IF PASSED AS AN JSON
			$work = json_decode($_POST['emp_qualificationarray'], true); 
			for($i=0; $i<count($work); $i++)
			{
				if($work[$i]['name']!=""){
					$record = array();
					$record[0] = $empid;
					$record[1] = $work[$i]['name'];
					$record[2] = $work[$i]['desig'];
					$record[3] = $work[$i]['fdate'];
					$record[4] =Utils::getDateformat($work[$i]['tdate']);
					$record[5] = $work[$i]['desc'];
					$record[6] = $mdate;
					$record[7] = $mid;
					$record[8] = $mdate;
					$record[9] = $mid;
					$record[10] = $mid;
					$record[11] = $orgid;
					
					$sqlwork = " INSERT INTO EmployeeQualification (EmployeeId, InstituteName, Degree, FOS, DOC, GPA, CreatedDate, CreatedById, LastModifiedDate, LastModifiedById, OwnerId, OrganizationId) values (?,?,?,?,?,?,?,?,?,?,?,?)";
					$querywork = $this->db->prepare($sqlwork);
					$querywork->execute($record);
				}
			}
			
			// INSERTING DOCUMENT RECORD OF EMPLOYEE IF PASSED AS AN JSON
			$work = json_decode($_POST['emp_documentarray'], true); 
			for($i=0; $i<count($work); $i++)
			{
				if($work[$i]['name']!=""){
					$docsts=isset($work[$i]['originaldoc'])?$work[$i]['originaldoc']:0;
					$doctype=isset($work[$i]['doctype'])?$work[$i]['doctype']:0;
					$record = array();
					$record[0] = $empid;
					$record[1] = $work[$i]['name'];
					$record[2] = Utils::encode5t($work[$i]['desig']);
					$record[3] = Utils::getDateformat($work[$i]['fdate']);
					$record[4] = Utils::getDateformat($work[$i]['tdate']);
					//$record[5] = $work[$i]['desc'];
					$record[5] = $mdate;
					$record[6] = $mid;
					$record[7] = $mdate;
					$record[8] = $mid;
					$record[9] = $mid;
					$record[10] = $orgid;
					$record[11] = $docsts;
					$record[12] = $doctype;					
					$sqlwork = " INSERT INTO EmployeeDocument (EmployeeId, DocumentTypeId, DocumentNumber, IssuedOn, ExpiredOn, CreatedDate, CreatedById, LastModifiedDate, LastModifiedById, OwnerId, OrganizationId,OriginalDocSts,DocType) values (?,?,?,?,?,?,?,?,?,?,?,?,?)";
					$querywork = $this->db->prepare($sqlwork);
					$querywork->execute($record);
				}
			}
			
			// INSERTING AND UPDATING DEPENDANT RECORD OF EMPLOYEE IF PASSED AS AN JSON
			$dependant = json_decode($_POST['emp_dependant'], true); 
			for($i=0; $i<count($dependant); $i++)
			{
				if($dependant[$i]['relate']!="" && $dependant[$i]['fname']!=""){
					$record = array();
					$record[0] = $empid;
					$record[1] = $dependant[$i]['relate'];
					$record[2] = $dependant[$i]['fname'];
					$record[3] = $dependant[$i]['lname'];
					$record[4] = Utils::getDateformat($dependant[$i]['bdate']);
					$record[5] = $dependant[$i]['nominee'];
					$record[6] = Utils::encode5t($dependant[$i]['contact']);
					
					
					$id = $dependant[$i]['id'];
					if($id){
						$sqlwork = " UPDATE EmployeeDependant SET EmployeeRelationId=?, FirstName=?, LastName=?, DOB=?, NomineePercent=?,Contact=? WHERE Id=?";
						$querywork = $this->db->prepare($sqlwork);
						$querywork->execute(array($dependant[$i]['relate'], $dependant[$i]['fname'], $dependant[$i]['lname'], $dependant[$i]['bdate'], $dependant[$i]['nominee'],$record[6],  $id));
					}else{
						$sqlwork = " INSERT INTO EmployeeDependant (EmployeeId, EmployeeRelationId, FirstName, LastName, DOB, NomineePercent,Contact) values (?,?,?,?,?,?,?)";
						$querywork = $this->db->prepare($sqlwork);
						$querywork->execute($record);
					}
				}
			}
			// INSERTING SKILLS OF EMPLOYEE IF PASSED AS AN JSON
			$skill = json_decode($_POST['emp_skill'], true); 
			for($i=0; $i<count($skill); $i++)
			{
				if($skill[$i]['skill']!=""){
					$record = array();
					$record[0] = $empid;
					$record[1] = (int)$skill[$i]['skill'];
					$record[2] = $skill[$i]['desc'];
					
					
					$sqlwork = " INSERT INTO EmployeeSkills (EmployeeId, SkillsId,Description) values (?,?,?)";
					$querywork = $this->db->prepare($sqlwork);
					$querywork->execute($record);
				}
			}
			
				//INSERTING CREDIT CARD DETAILS OF EMPLOYEE 
					
					$creditcard = json_decode($_POST['emp_creditcard'], true); 
					for($i=0; $i<count($creditcard); $i++)
					{
						if($creditcard[$i]['creditcardid']!="" && $creditcard[$i]['bankid']!=""){
							$record = array();
							$record[0] = $empid;
							$record[1] = $creditcard[$i]['creditcardid'];
							$record[2] = $creditcard[$i]['bankid'];
							$record[3] = Utils::encode5t($creditcard[$i]['creditcard_no']);
							$record[4] = Utils::getDateformat($creditcard[$i]['credit_issuedate']);
							$record[5] = Utils::getDateformat($creditcard[$i]['credit_validdate']);
							$record[6] = $creditcard[$i]['credit_limit'];
							
							
							
							$sqlwork = " INSERT INTO EmployeeCreditCard (EmployeeId, CreditCardId, BankId,CreditCardNo, IssueDate, ValidTill, CreditCardLimit) values (?,?,?,?,?,?,?)";
							$querywork = $this->db->prepare($sqlwork);
							$querywork->execute($record);
						}
					}
					
					//INSERTING INSURANCE DETAILS OF EMPLOYEE 
					
					$insurance = json_decode($_POST['emp_insurance'], true); 
					for($i=0; $i<count($insurance); $i++)
					{
						if($insurance[$i]['insuranceid']!="" && $insurance[$i]['insurance_period']!=""){
							$record = array();
							$record[0] = $empid;
							$record[1] = $insurance[$i]['insuranceid'];
							$record[2] = $insurance[$i]['insurance_period'];
							$record[3] = $insurance[$i]['insured_amt'];
							$record[4] = $insurance[$i]['premium_amt'];
							$record[5] =Utils::getDateformat( $insurance[$i]['insurance_validdate']);
							$record[6] = $insurance[$i]['insurance_nominee'];
							
							$sqlwork = " INSERT INTO EmployeeInsuranceDetails ( EmployeeId, InsuranceId, InsurancePeriod,  InsuredAmount, PremiumAmount,  ValidTill, NomineeDetails) values (?,?,?,?,?,?,?)";
							$querywork = $this->db->prepare($sqlwork);
							$querywork->execute($record);
						}
					}
					//INSERTING BANK DETAILS OF EMPLOYEE 
					
					$bank = json_decode($_POST['emp_bank'], true); 
					for($i=0; $i<count($bank); $i++)
					{
						if($bank[$i]['bankid']!="" && $bank[$i]['iban_no']!=""){
							$record = array();
							$record[0] = $empid;
							$record[1] = $bank[$i]['bankid'];
							$record[2] = Utils::encode5t($bank[$i]['iban_no']);
							$record[3] = Utils::encode5t($bank[$i]['swiftcode']);
							$record[4] = Utils::encode5t($bank[$i]['branch']);
							$record[5] = $bank[$i]['status'];
							$record[6] = $bank[$i]['agent_id'];
							
							$sqlbank = " INSERT INTO EmployeeBankDetails ( EmployeeId, BankId, IBAN,  SwiftCode, Branch,BankStatus,agent_id) values (?,?,?,?,?,?,?)";
							$querybank = $this->db->prepare($sqlbank);
							$querybank->execute($record);
						}
					}
					
					//INSERTING BANKLOAN DETAILS OF EMPLOYEE 
					
					$bankloan = json_decode($_POST['emp_bankloan'], true); 
					for($i=0; $i<count($bankloan); $i++)
					{
						if($bankloan[$i]['bankid']!="" && $bankloan[$i]['loan_amt']!=""){
							$record = array();
							$record[0] = $empid;
							$record[1] = $bankloan[$i]['bankid'];
							$record[2] = Utils::encode5t($bankloan[$i]['loan_amt']);
							$record[3] = Utils::encode5t($bankloan[$i]['tenure']);
							$record[4] = Utils::encode5t($bankloan[$i]['emi']);
							
							$sqlbankloan = " INSERT INTO EmployeeBankLoan ( EmployeeId, BankId, LoanAmount,  Tenure, EMI) values (?,?,?,?,?)";
							$querybankloan = $this->db->prepare($sqlbankloan);
							$querybankloan->execute($record);
							
							
							
						}
					}
					
			// INSERTING AND UPDATING FamilyDetail OF EMPLOYEE IF PASSED AS AN JSON
			$ltadetails = json_decode($_POST['emp_ltadetails'], true); 
			
			for($i=0; $i<count($ltadetails); $i++)
			{
				if($ltadetails[$i]['fname']!="" && $ltadetails[$i]['bdate']!="" && $ltadetails[$i]['passportno']!="" && $ltadetails[$i]['emiratesid']!=""){
					$record = array();
					$record[0] = $empid;
					$record[1] = $ltadetails[$i]['fname'];
					$record[2] = Utils::getDateformat($ltadetails[$i]['bdate']);
					$record[3] = Utils::encode5t($ltadetails[$i]['passportno']);
					$record[4] = Utils::encode5t($ltadetails[$i]['emiratesid']);
					$record[5] = $ltadetails[$i]['relate'];				
					
					$sqlwork = " INSERT INTO EmployeeLTADetail ( EmployeeId, Name, DOB, PassportNo, EmiratesId,Relation) values (?,?,?,?,?,?)";
					$querywork = $this->db->prepare($sqlwork);
					$querywork->execute($record);
					
				}
			}
			
					
											
					
			// INSERTING EMPLOYEE SEQUENCE GENERATED TO KEEP SEPARATE OF NEXT EMPLOYEE ID 
			$sqlseq = "INSERT INTO EmployeeSequence (Id,OrganizationId) values(?,?)";
			$queryseq = $this->db->prepare($sqlseq);
			$queryseq->execute(array($maxid,$orgid));
			
			
			$count =  $query->rowCount();		
	}		
			
			if ($count == 1) {
				
				$status =true;
				$successMsg = EMPLOYEE_MODULE_CREATION_SUCCESS;	
				
				////////create employee history///////
				$title="Joining";
				$doj=$_POST['emp_doj'];
				$designame=Utils::getName($desig,'DesignationMaster','Name',$this->db);
				$msg="Joined the company on $doj as a $designame";
				$sql1 = "INSERT INTO EmployeeHistory ( EmployeeId, Title, EventDate, Message, OrganizationId) VALUES (?, ?, ?, ?, ? )";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array( $empid, $title, Utils::getDateformat($doj), $msg, $orgid));
				/////////////CREATING USER///////////////////
				
				$sqlrole="SELECT * FROM UserMaster WHERE EmployeeId= :id OR Username= :name";
				$queryrole = $this->db->prepare($sqlrole);
				$queryrole->execute(array(':id' => $empid, ':name' => $cmp_email ));
				$con =  $queryrole->rowCount();	
				if($con>=1){
					$status =true;
					$successMsg = EMPLOYEE_MODULE_CREATION_SUCCESS;		
				}
				else{
				$rand= rand(1000000,10000000);
				$pwd = dechex($rand);
				$pwd = strtoupper($pwd);
				$pwd = "ubipass";
				$pwd = Utils::encode5t( $pwd);
									
				$sql1 = "INSERT INTO UserMaster (EmployeeId, Password, Username, RoleId, OrganizationId,  LastModifiedDate, LastModifiedById, CreatedDate, CreatedById, OwnerId,username_mobile) VALUES (?, ?, ?,  ?, ?, ?, ?, ?, ?, ?, ? )";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array( $empid,  $pwd, $cmp_email, $desig, $orgid, $mdate, $mid, $mdate, $mid, $mid, Utils::encode5t($_POST['emp_contact1'])));
			
			   $status =true;
			   $successMsg = EMPLOYEE_MODULE_CREATION_SUCCESS;
			   }
			}
			elseif($count1>=1){
				$status =false;
				$errorMsg = EMPLOYEE_MODULE_UPDATION_DUPLICATE;
			}	
			else {
			   $status =false;
			   $errorMsg = EMPLOYEE_MODULE_CREATION_FAILED;
			}
			
		  $this->db->commit(); 
			  
		}catch(PDOException $e)
		{
			$status =false;
			$this->db->rollBack();
			$errorMsg = 'Message: ' .$e->getMessage();
		}catch(Exception $e)
		{
			$status =false;
			$this->db->rollBack();
			$errorMsg = 'Message: ' .$e->getMessage();
		} 
		}
		else{
		$result = array();
		$result['status']=false;
		$result['errorMsg']="You can't add more employees.";
		echo json_encode($result);	
		}	
		
		$result['emp_id']=$empid;
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }

  
    /**
     * Deletes a specific department
     * @param  $did contains department id
     * @return array feedback conatining status of request
     */
    public function Delete($did)
    {
        $result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();        
		$mdate = date("Y-m-d H:i:s");		
		$empcode=0;		
		$orgid=$_SESSION['ubihrm_org_id'];
		try{	
			
			$sql = "Select EmployeeCode FROM EmployeeMaster WHERE Id = :id ";
			$query = $this->db->prepare($sql);
			$query->execute(array(':id' => $did));
			while($row=$query->fetch())
			{
				$empcode=$row->EmployeeCode;
			}
			
			
			$sql = "DELETE FROM EmployeeHistory WHERE EmployeeId = :id ";
			$query = $this->db->prepare($sql);
			$query->execute(array(':id' => $did));
			
			$sql = "DELETE FROM EmployeeChecklist WHERE EmployeeId = :id ";
			$query = $this->db->prepare($sql);
			$query->execute(array(':id' => $did));
			
			$sql = "DELETE FROM EmployeeSalaryDetails WHERE EmployeeId = :id ";
			$query = $this->db->prepare($sql);
			$query->execute(array(':id' => $did));
			
			$sql = "DELETE FROM SalaryHistory WHERE EmployeeId = :id ";
			$query = $this->db->prepare($sql);
			$query->execute(array(':id' => $did));
			
			$sql = "DELETE FROM UserMaster WHERE EmployeeId = :id ";
			$query = $this->db->prepare($sql);
			$query->execute(array(':id' => $did));
			
			$sql = "DELETE FROM EmployeeWorkExperience WHERE EmployeeId = :id ";
			$query = $this->db->prepare($sql);
			$query->execute(array(':id' => $did));
			
			$sql = "DELETE FROM EmployeeQualification WHERE EmployeeId = :id ";
			$query = $this->db->prepare($sql);
			$query->execute(array(':id' => $did));
			
			$sql = "DELETE FROM EmployeeDocument WHERE EmployeeId = :id ";
			$query = $this->db->prepare($sql);
			$query->execute(array(':id' => $did));
			
			$sql = "DELETE FROM EmployeeDependant WHERE EmployeeId = :id ";
			$query = $this->db->prepare($sql);
			$query->execute(array(':id' => $did));
						
			$sql = "DELETE FROM EmployeeReference WHERE EmployeeId = :id ";
			$query = $this->db->prepare($sql);
			$query->execute(array(':id' => $did));
			
			$sql = "DELETE FROM EmployeeInsuranceDetails WHERE EmployeeId = :id ";
			$query = $this->db->prepare($sql);
			$query->execute(array(':id' => $did));
			
			$sql = "DELETE FROM EmployeeCreditCard WHERE EmployeeId = :id ";
			$query = $this->db->prepare($sql);
			$query->execute(array(':id' => $did));
			
			$sql = "DELETE FROM EmployeeSkills WHERE EmployeeId = :id ";
			$query = $this->db->prepare($sql);
			$query->execute(array(':id' => $did));
			
			$sql = "SELECT Id FROM EmployeeLeave WHERE EmployeeId = :id ";
			$query = $this->db->prepare($sql);
			$query->execute(array(':id' => $did));
			while($row=$query->fetch())
			{
				$sid=$row->Id;
				$sql1 = "DELETE FROM LeaveApproval WHERE LeaveId = :id ";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array(':id' => $sid));
				$sql1 = "DELETE FROM EmployeeLeaveChild WHERE EmployeeLeaveId = :id ";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array(':id' => $sid));
				$sql1 = "DELETE FROM EmployeeLeave WHERE Id = :id ";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array(':id' => $sid));
			}
			
			$sql = "SELECT Id FROM SeveranceMaster WHERE EmployeeId = :id ";
			$query = $this->db->prepare($sql);
			$query->execute(array(':id' => $did));
			while($row=$query->fetch())
			{
				$sid=$row->Id;
				$sql1 = "DELETE FROM ResignationApproval WHERE ResignationId = :id ";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array(':id' => $sid));
				$sql1 = "DELETE FROM SeveranceMaster WHERE Id = :id ";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array(':id' => $sid));
			}
			
			
			$sql = "DELETE FROM EmployeeBankDetails WHERE EmployeeId = :id ";
			$query = $this->db->prepare($sql);
			$query->execute(array(':id' => $did));
			
			$sql = "DELETE FROM EmployeeBankLoan WHERE EmployeeId = :id ";
			$query = $this->db->prepare($sql);
			$query->execute(array(':id' => $did));
			
			$sql = "DELETE FROM EmployeeCreditCard WHERE EmployeeId = :id ";
			$query = $this->db->prepare($sql);
			$query->execute(array(':id' => $did));
			
			$sql = "DELETE FROM EmployeeLTADetail WHERE EmployeeId = :id ";
			$query = $this->db->prepare($sql);
			$query->execute(array(':id' => $did));
			
			$sql = "DELETE FROM GenerateNotification WHERE EmployeeId = :id ";
			$query = $this->db->prepare($sql);
			$query->execute(array(':id' => $did));
			
			$sql = "DELETE FROM EmployeeIncentive WHERE EmployeeId = :id ";
			$query = $this->db->prepare($sql);
			$query->execute(array(':id' => $did));
			
			$sql = "DELETE FROM AttendanceMaster WHERE EmployeeId = :id ";
			$query = $this->db->prepare($sql);
			$query->execute(array(':id' => $did));
			
			$sql = "DELETE FROM LeaveHistory WHERE EmployeeId = :id ";
			$query = $this->db->prepare($sql);
			$query->execute(array(':id' => $did));
			
			$sql = "DELETE FROM LoginHistory WHERE loggedinById = :id ";
			$query = $this->db->prepare($sql);
			$query->execute(array(':id' => $did));
			
			$sql = "SELECT Id FROM EmployeeAssessment WHERE EmployeeId = :id ";
			$query = $this->db->prepare($sql);
			$query->execute(array(':id' => $did));
			while($row=$query->fetch())
			{
				$sid=$row->Id;
				$sql1 = "DELETE FROM EmployeeAssessmentChild WHERE EmployeeAssessmentId = :id ";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array(':id' => $sid));
				$sql1 = "DELETE FROM EmployeeAssessmentApproval WHERE EmployeeAssessmentId = :id ";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array(':id' => $sid));
				$sql1 = "DELETE FROM EmployeeAssessment WHERE Id = :id ";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array(':id' => $sid));
			}
			
			$sql = "SELECT Id FROM SkillGapAssessment WHERE EmployeeId = :id ";
			$query = $this->db->prepare($sql);
			$query->execute(array(':id' => $did));
			while($row=$query->fetch())
			{
				$sid=$row->Id;
				$sql1 = "DELETE FROM SkillGapChild WHERE SkillGapId = :id ";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array(':id' => $sid));
				$sql1 = "DELETE FROM SkillGapApproval WHERE SkillGapId = :id ";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array(':id' => $sid));
				$sql1 = "DELETE FROM SkillGapAssessment WHERE Id = :id ";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array(':id' => $sid));
			}
			
			$sql = "SELECT Id FROM SalaryMaster WHERE EmployeeId = :id ";
			$query = $this->db->prepare($sql);
			$query->execute(array(':id' => $did));
			while($row=$query->fetch())
			{
				$sid=$row->Id;
				$sql1 = "DELETE FROM SalaryChild WHERE SalaryId = :id ";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array(':id' => $sid));
				$sql1 = "DELETE FROM SalaryMaster WHERE Id = :id ";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array(':id' => $sid));
			}
			
			$sql = "SELECT Id FROM BenefitCompansationMaster WHERE EmployeeId = :id ";
			$query = $this->db->prepare($sql);
			$query->execute(array(':id' => $did));
			while($row=$query->fetch())
			{
				$sid=$row->Id;
				$sql1 = "DELETE FROM BenefitCompansationChild WHERE BenefitCompansationId = :id ";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array(':id' => $sid));
				$sql1 = "DELETE FROM BenefitCompansationMaster WHERE Id = :id ";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array(':id' => $sid));
			}
			
			$sql = "SELECT Id FROM JobModificationMaster WHERE EmployeeId = :id ";
			$query = $this->db->prepare($sql);
			$query->execute(array(':id' => $did));
			while($row=$query->fetch())
			{
				$sid=$row->Id;
				$sql1 = "DELETE FROM JobModificationChild WHERE JobId = :id ";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array(':id' => $sid));
				$sql1 = "DELETE FROM JobModificationMaster WHERE Id = :id ";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array(':id' => $sid));
			}
			
			
			$sql = "DELETE FROM AssetsIssued WHERE EmployeeId = :id ";
			$query = $this->db->prepare($sql);
			$query->execute(array(':id' => $did));
			
			
			$sql = "SELECT Id FROM GrievanceMaster WHERE EmployeeIds = :id ";
			$query = $this->db->prepare($sql);
			$query->execute(array(':id' => $did));
			while($row=$query->fetch())
			{
				$sid=$row->Id;
				$sql1 = "DELETE FROM GrievanceApproval WHERE GrievanceId = :id ";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array(':id' => $sid));
				$sql1 = "DELETE FROM GrievanceMaster WHERE Id = :id ";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array(':id' => $sid));
			}
			
			$sql = "DELETE FROM OfficLetterMaster WHERE EmployeeId = :id ";
			$query = $this->db->prepare($sql);
			$query->execute(array(':id' => $did));
			
			$sql = "SELECT Id FROM DocumentReleaseMaster WHERE EmployeeId = :id ";
			$query = $this->db->prepare($sql);
			$query->execute(array(':id' => $did));
			while($row=$query->fetch())
			{
				$sid=$row->Id;
				$sql1 = "DELETE FROM DocumentApproval WHERE DocumentId = :id ";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array(':id' => $sid));
				$sql1 = "DELETE FROM DocumentReleaseMaster WHERE Id = :id ";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array(':id' => $sid));
			}
			
			$sql = "SELECT Id FROM CertificateReleaseMaster WHERE EmployeeId = :id ";
			$query = $this->db->prepare($sql);
			$query->execute(array(':id' => $did));
			while($row=$query->fetch())
			{
				$sid=$row->Id;
				$sql1 = "DELETE FROM CertificateApproval WHERE CertificateId = :id ";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array(':id' => $sid));
				$sql1 = "DELETE FROM CertificateReleaseMaster WHERE Id = :id ";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array(':id' => $sid));
			}
			$sql = "DELETE FROM DocumentTracking WHERE EmployeeId = :id ";
			$query = $this->db->prepare($sql);
			$query->execute(array(':id' => $did));
			
			
			$sql = "SELECT Id FROM SalaryAdvance WHERE EmployeeId = :id ";
			$query = $this->db->prepare($sql);
			$query->execute(array(':id' => $did));
			while($row=$query->fetch())
			{
				$sid=$row->Id;
				$sql1 = "DELETE FROM SalaryApproval WHERE SalaryAdvanceId = :id ";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array(':id' => $sid));
				$sql1 = "DELETE FROM SalaryAdvance WHERE Id = :id ";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array(':id' => $sid));
			}
			$sql = "DELETE FROM EmployeeMaster WHERE Id = :id ";
			$query = $this->db->prepare($sql);
			$query->execute(array(':id' => $did));
		
			$sql = "DELETE FROM EmployeeSequence WHERE Id = :id and OrganizationId= :org";
			$query = $this->db->prepare($sql);
			$query->execute(array(':id' => $empcode, ':org' => $orgid));
			
			$count =  $query->rowCount();		
		
		
        if ($count == 1) {
           $status =true;
		   $successMsg = EMPLOYEE_MODULE_DELETE_SUCCESS;
        }else {
           $status =false;
		   $errorMsg = EMPLOYEE_MODULE_DELETE_FAILED;
        }
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	 public function DeletenewEmp($did)
    {
        $result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();        
		$mdate = date("Y-m-d H:i:s");		
				
		try{	
			
			$sql = "DELETE FROM EmployeeNewJoiningWorkExperience WHERE EmployeeId = :id ";
			$query = $this->db->prepare($sql);
			$query->execute(array(':id' => $did));
			
			$sql = "DELETE FROM EmployeeNewJoiningQualification WHERE EmployeeId = :id ";
			$query = $this->db->prepare($sql);
			$query->execute(array(':id' => $did));
			
			$sql = "DELETE FROM EmployeeNewJoiningDocument WHERE EmployeeId = :id ";
			$query = $this->db->prepare($sql);
			$query->execute(array(':id' => $did));
									
			$sql = "DELETE FROM EmployeeNewJoiningReference WHERE EmployeeId = :id ";
			$query = $this->db->prepare($sql);
			$query->execute(array(':id' => $did));
						
			$sql = "DELETE FROM EmployeeNewJoiningSkills WHERE EmployeeId = :id ";
			$query = $this->db->prepare($sql);
			$query->execute(array(':id' => $did));
			
			$sql = "DELETE FROM EmployeeNewJoinee WHERE Id = :id ";
			$query = $this->db->prepare($sql);
			$query->execute(array(':id' => $did));
		
			$count =  $query->rowCount();		
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
        if ($count == 1) {
           $status =true;
		   $successMsg = EMPLOYEE_MODULE_DELETE_SUCCESS;
        }else {
           $status =false;
		   $errorMsg = EMPLOYEE_MODULE_DELETE_FAILED;
        }
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	
	
	
	
	public function getOtherMasterData($val, $type)
	{
		$empcode ="";
		$sql = "SELECT DisplayName FROM OtherMaster WHERE ActualValue = ? and OtherType=?";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array( $val, $type ));
			while($row = $query->fetch())
			{
				$empcode =  $row->DisplayName;;
			}
		}catch(Exception $e) {
			
		}
		return $empcode;
	}
	
	public function getCode($id)
	{
		$empcode ="";
		$sql = "SELECT EmployeeCode FROM EmployeeMaster WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$empcode =  $row->EmployeeCode;;
			}
		}catch(Exception $e) {
			
		}
		return $empcode;
	}
	
	public function getLastSalaryHistoryUpdated($id)
	{
		$empcode =date('Y-m-d');
		$sql = "SELECT CreatedDate FROM SalaryHistory WHERE EmployeeId = :id order by CreatedDate desc limit 1";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$empcode =  $row->CreatedDate;;
			}
		}catch(Exception $e) {
			
		}
		return $empcode;
	}
	
	
	public function getDesignation($id)
	{
		$name ="";
		$sql = "SELECT Designation FROM EmployeeMaster WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$name =  Utils::getName($row->Designation,'DesignationMaster','Name',$this->db);
				
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}
	
	public function getdoc($id)
	{
		$empcode ="";
		$sql = "SELECT * FROM EmployeeDocument WHERE EmployeeId = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$empcode =  $row->Id;
			}
		}catch(Exception $e) {
			
		}
		return $empcode;
	}
	
	public function getprobationdays($id)
	{
		$empcode ="";
		$sql = "SELECT datediff(DATE_ADD(DOJ, INTERVAL ProvisionPeriod month), curdate()) as daysleft  FROM EmployeeMaster WHERE Id = :id";
		 
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$empcode =  $row->daysleft;
			}
		}catch(Exception $e) {
			
		}
		return $empcode;
	}
	
	
	public function getDomain($id)
	{
		$empcode ="";
		$sql = "SELECT * FROM Organization WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$url =  $row->Website;
				$domain = str_replace('www.', '', $url);
				$domain = strtolower($domain);
			}
		}catch(Exception $e) {
			
		}
		return $domain;
	}
	
	
	public function getDataTable($editper, $deleteper,$viewper)
	{
		$sTable = 'EmployeeMaster';
		$sIndexColumn = "Id";
		$userid = $_SESSION['ubihrm_user_id'];
		//$roleid = $_SESSION['ubihrm_user_roleid'];
		$aColumns = array('EmployeeCode', 'FirstName','CurrentContactNumber','CompanyEmail','DOB','Gender','MaritalStatus','Nationality','Visa','DOJ','DOC','EmployeeCTC','ReportingTo', 'Division', 'Department', 'Channel','Designation', 'Grade', 'Shift', 'Location', 'EmployeeStatus','EmploymentType','DOL','BankAccount', 'Id');
		//$roleid = $this->getRoleIds($roleid); 'CreatedById', 'CreatedDate', 'LastModifiedById', 'LastModifiedDate',
		
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY  ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		$orgid=$_SESSION['ubihrm_org_id'];
		$sts=$_SESSION['ubihrm_user_sts'];
		
		$sWhere = "";
		$hrsts=$_SESSION['ubihrm_hr_sts'];
			
		if($sts==1 || $hrsts==1){
			$sWhere = " WHERE  OrganizationId= $orgid  and (DOL='0000-00-00' or DOL>curdate()) ";
		}else{
			$ids = Utils::getReportingIds($userid, $this->db);
			$sWhere = " WHERE (Id in ($ids) AND OrganizationId= $orgid)  and (DOL='0000-00-00' or DOL>curdate()) ";
		}
		
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " AND (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id"){
				continue;
				}
				if($aColumns[$i]=="FirstName"){
					$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR  MiddleName LIKE '%".( $_GET['sSearch'] )."%' OR  LastName LIKE '%".( $_GET['sSearch'] )."%' OR ";
				} 
				elseif($aColumns[$i]=="CompanyEmail" || $aColumns[$i]=="CurrentContactNumber"){
					$sWhere .= $aColumns[$i]." LIKE '%".Utils::encode5t( $_GET['sSearch'] )."%' OR ";
				}
				/* elseif($aColumns[$i]=="CurrentContactNumber"){
					$sWhere .= $aColumns[$i]." LIKE '%".Utils::encode5t( $_GET['sSearch'] )."%' OR ";
				} */else{
					$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
				}
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		$flg=false;
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				
				if($aColumns[$i]=="DOL"){
					$flg=true;
					$sWhere .= $aColumns[$i]."  ".($_GET['sSearch_'.$i])." '0000-00-00' ";
				}else{
					$sWhere .= $aColumns[$i]." = '".($_GET['sSearch_'.$i])."' ";
				}
			}
		}
		if(!$flg){
			//$sWhere .= " and (DOL='0000-00-00' or DOL>curdate())";
		}
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		
		
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id")
				{
					$edit =""; $delete=""; $checklist="";
					if($editper){
						$edit = '<a rel="tooltip" title="Edit" href="'.URL.'employee/editemployee/'.Utils::encode5t($aRow->{$aColumns[$i]}).'" ><i class="fa fa-edit"></i></a>';
						
						
					}else{
						$edit = '<a href="#" rel="tooltip" title="No permission to edit"><i class="fa fa-edit"></i></a>';
					}
					if($viewper){
											
						$checklist = '<a rel="tooltip" title="Checklist" href="'.URL.'employee/getchecklist/'.Utils::encode5t($aRow->{$aColumns[$i]}).'" ><i class="fa fa-check-square-o"></i></a>';
					}else{
						
						$checklist = '<a href="#" rel="tooltip" title="No permission to view"><i class="fa fa-check-square-o"></i></a>';
					}
					if($deleteper){
						$delete ='<a rel="tooltip"  title="Delete" data-href="'.URL.'employee/deleteemployee/'.$aRow->{$aColumns[$i]}.'" data-toggle="modal" data-target="#confirm" href="#" ><i class="fa fa-trash"></i></a>';
					}else{
						$delete = '<a href="#" rel="tooltip" title="No permission to delete"><i class="fa fa-trash"></i></a>';
					}	
						$edit1 = '<a rel="tooltip" title="History" href="'.URL.'employee/timeline/'.Utils::encode5t($aRow->{$aColumns[$i]}).'/1" ><i class="fa fa-book"></i></a>';
						
						$hierchy = '<a rel="tooltip" title="Hierarchy" href="'.URL.'employee/hierarchy/'.Utils::encode5t($aRow->{$aColumns[$i]}).'/1" ><i class="fa fa-sitemap"></i></a>';
						
					$row[] =$edit."&nbsp;|&nbsp;".$delete."&nbsp;|&nbsp;".$edit1."&nbsp;|&nbsp;".$hierchy."&nbsp;|&nbsp;".$checklist;
				}
				else if($aColumns[$i]=="EmployeeCode")
				{
					$row[] = '<a href="'.URL.'employee/viewemployee/'.Utils::encode5t($aRow->Id).'/1">'.$aRow->{$aColumns[$i]}.'</a>';
					
				}
				elseif($aColumns[$i]=="EmployeeCTC"){	
					$divcur= Utils::getDivisioncurrency($aRow->Division,$this->db);
					$row[] = Utils::numberformatter($aRow->{$aColumns[$i]},$divcur);
				}
				elseif($aColumns[$i]=="DOB" || $aColumns[$i]=="DOC" || $aColumns[$i]=="DOJ" || $aColumns[$i]=="DOL"){											
					$row[] = Utils::dateformatter($aRow->{$aColumns[$i]});
				}
				elseif($aColumns[$i]=="Division" || $aColumns[$i]=="Department" || $aColumns[$i]=="Channel" || $aColumns[$i]=="Designation" || $aColumns[$i]=="Grade" || $aColumns[$i]=="Shift" || $aColumns[$i]=="Nationality" || $aColumns[$i]=="Visa" || $aColumns[$i]=="Location"){
											
					$row[] =Utils::getName( $aRow->{$aColumns[$i]}, $aColumns[$i].'Master', "Name", $this->db);
				}
				elseif($aColumns[$i]=="CreatedDate" || $aColumns[$i]=="LastModifiedDate"){
					$row[] =Utils::datetimeformatter($aRow->{$aColumns[$i]});
				}
				elseif($aColumns[$i]=="ReportingTo" || $aColumns[$i]=="LastModifiedById" || $aColumns[$i]=="CreatedById"){											
					$row[] =Utils::getEmployeeName( $aRow->{$aColumns[$i]},$this->db);
				}
				elseif($aColumns[$i]=="FirstName"){											
					$row[] =Utils::getEmployeeName( $aRow->Id,$this->db);
				}
				elseif($aColumns[$i]=="CurrentContactNumber"){
					$row[] =Utils::decode5t($aRow->{$aColumns[$i]});
				}
				elseif($aColumns[$i]=="CompanyEmail"){
					$row[] =Utils::decode5t($aRow->{$aColumns[$i]});
				}
				
				elseif($aColumns[$i]=="Gender" || $aColumns[$i]=="MaritalStatus" || $aColumns[$i]=="EmploymentType"){
											
					$row[] =$this->getOtherMasterData( $aRow->{$aColumns[$i]}, $aColumns[$i]);
				}
				elseif($aColumns[$i]=="EmployeeStatus"){
											
					$row[] =Utils::getOtherName( $aRow->{$aColumns[$i]}, 'EmployeeStatus', $this->db);
				}
				elseif($aColumns[$i]=="BankAccount"){
											
					$row[] =Utils::getName( $aRow->{$aColumns[$i]}, 'SalaryTypeMaster','Name', $this->db);
				}
				else
				{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
	/////////////////// Expericence Certificate//////////////
	
	public function getDetailEmp($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$empid = $request[2];	//SALARY ID CONTAINS IN ARRAY THIRD VALUE;
		
		$bankname =""; $bankcode =""; $bankacct =0;
       
				////////////////   FIND OUT THE COMPANY DETAILS ARE AVAILABLE  /////////////////////////////				
				$sql1 = "SELECT Name,Logo FROM Organization WHERE Id = ?";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array( $orgid ));
				
				while($row1 = $query1->fetch())
				{
					$res['companyname'] = $row1->Name;
					$res['logo'] = URL."public/uploads/".$row1->Logo;
					
				}
				
				////////////////   FIND OUT THE EMPLOYEE DETAILS ARE AVAILABLE  /////////////////////////////				
				$sql1 = "SELECT * FROM EmployeeMaster WHERE Id = ? and OrganizationId = ?";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array( $empid, $orgid ));
				$count=$query1->rowCount();
				while($row1 = $query1->fetch())
				{
					$res['id'] = (int)$row1->Id;
					$res['name'] = ucwords(strtolower($row1->FirstName." ".$row1->LastName));
					$res['empcode'] = $row1->EmployeeCode;
					$res['empdivision'] = $this->getName($row1->Division,'DivisionMaster');
					$res['empdept'] = $this->getName($row1->Department,'DepartmentMaster');
					$res['empchannel'] = $this->getName($row1->Channel,'ChannelMaster');
					$res['empdesig'] = $this->getName($row1->Designation,'DesignationMaster');
					$res['empshift'] =$this->getName( $row1->Shift,'ShiftMaster');
					$res['empgrade'] = $this->getName($row1->Grade,'GradeMaster');
					$res['empctc'] = $row1->EmployeeCTC;
					$data[] = $res;
				}
				
				////////////////   FIND OUT THE SALARY DEDUCTION HEADS ARE AVAILABLE  /////////////////////////////				
				/* $sql1 = "SELECT *, sh.headtype as type FROM SalaryHead sh, SalaryChild sc where sc.headtype=1 and sc.headid=sh.id and salaryid=?";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array( $salaryid ));
				while($row1 = $query1->fetch())
				{
					$res1 = array();
					$res1['id'] = (int)$row1->Id;
					$res1['amount'] = (int)$row1->HeadAmount;					
					$res1['name'] =(($row1->type==3)?"(-) ":"(+) ").$row1->Name;
					$res1['type'] = 1;
					$res1['headtype'] = (int)($row1->type==3)?0:$row1->type;
					$res1['payslip'] = (int)$row1->IncludeInPayslip;
					$res1['additions'] = ($row1->type==3)?0:1;
					$headarray[]=$res1;
					if($row1->type==3)
					$totaldeduction += (int)$row1->HeadAmount;
					else
					$total += (int)$row1->HeadAmount;
				} */
				///////////// LIST OUT THE OTHER SALARY HEAD FIXED FOR ALL ORGANISATION AND APPLY TO SALARY ////////////////////////		
				/* $sql1 = "SELECT * FROM SalaryOtherHead sh, SalaryChild sc where sc.headtype=2 and sc.headid=sh.id and sc.salaryid=?";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array( $salaryid ));
				while($row1 = $query1->fetch())
				{
					$res1 = array();
					$res1['id'] = (int)$row1->Id;
					$res1['amount'] = (int)$row1->HeadAmount;
					$res1['name'] =(($row1->Type==0)?"(-) ":"(+) ").$row1->Name;
					$res1['type'] = 2;
					$res1['headtype'] = (int)$row1->Type;
					$res1['payslip'] = (int)$row1->IncludeInPayslip;
					$res1['additions'] = ($row1->Type==0)?0:1;
					$headarray[]=$res1;
					
					if($row1->Type)
					$total += (int)$row1->HeadAmount;
					else
					$totaldeduction += (int)$row1->HeadAmount;
				}
				
				
				
				
				$res['salarydetail'] = $headarray;
				$res['emptotal'] = $total;
				$res['emptotaldeduction'] = $totaldeduction;
				$res['netpay'] = $total-$totaldeduction;
				$data[] = $res;
				}}
			*/
       
		
		if ($count == 1) {
           $status =true;
		   $successMsg = SALARYMASTER_MODULE_GETDETAIL_SUCCESS;
        } else {
           $status =false;
		   $errorMsg=SALARYMASTER_MODULE_GETDETAIL_FAILED;
        }
		$result["data"] =$data;
		$result['status']=$status;
		//$result['currentdate']=Utils::dateformatter(date("Y-m-d"));
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
	public function getName($id, $tablename, $column='Name')
	{
		$name ="";
		$sql = "SELECT $column FROM $tablename WHERE Id = :id";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $id ));
			while($row = $query->fetch())
			{
				$name = $row->$column;
			}
		}catch(Exception $e) {
			
		}
		return $name;
	}
	/////////////////// Expericence Certificate//////////////
	public function getExEmployeeTable($editper, $deleteper){
		$sTable = 'EmployeeMaster';
		$sIndexColumn = "Id";
		$userid = $_SESSION['ubihrm_user_id'];
		//$roleid = $_SESSION['ubihrm_user_roleid'];
		$aColumns = array('EmployeeCode', 'FirstName','CurrentContactNumber','HomeEmailId','DOB','Gender','MaritalStatus','Nationality','Visa','DOJ','DOC','EmployeeCTC','ReportingTo', 'Division', 'Department', 'Channel','Designation', 'Grade', 'Shift', 'Location', 'EmployeeStatus','EmploymentType','DOL', 'Id');
		
		//$roleid = $this->getRoleIds($roleid); 'CreatedById', 'CreatedDate', 'LastModifiedById', 'LastModifiedDate',
		
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY  ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		
		$orgid=$_SESSION['ubihrm_org_id'];
		$sts=$_SESSION['ubihrm_user_sts'];
		
		$sWhere = "";
		$hrsts=$_SESSION['ubihrm_hr_sts'];
			
		if($sts==1 || $hrsts==1){
			$sWhere = " WHERE  OrganizationId= $orgid and (DOL!='0000-00-00' and DOL<=curdate()) ";
		}else{
			$ids = Utils::getExReportingIds($userid, $this->db);
			$sWhere = " WHERE (Id in ($ids) AND OrganizationId= $orgid) and (DOL!='0000-00-00' and DOL<=curdate()) ";
		}
		
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " AND (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id"){
				continue;
				}
				if($aColumns[$i]=="FirstName"){
					$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR  MiddleName LIKE '%".( $_GET['sSearch'] )."%' OR  LastName LIKE '%".( $_GET['sSearch'] )."%' OR ";
				}
				elseif($aColumns[$i]=="HomeEmailId" || $aColumns[$i]=="CurrentContactNumber"){
					$sWhere .= $aColumns[$i]." LIKE '%".Utils::encode5t( $_GET['sSearch'] )."%' OR ";
				}else{
					$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
				}
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		$flg=false;
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				
				if($aColumns[$i]=="DOL"){
					$flg=true;
					$sWhere .= $aColumns[$i]."  ".($_GET['sSearch_'.$i])." '0000-00-00' ";
				}else{
					$sWhere .= $aColumns[$i]." = '".($_GET['sSearch_'.$i])."' ";
				}
			}
		}
		if($flg){
			$sWhere .= " and (DOL!='0000-00-00' and DOL<curdate())";
		}
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		
		
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id")
				{
					$edit =""; $delete="";
					
						$row[] = '<a rel="tooltip" title="History" href="'.URL.'employee/timeline/'.Utils::encode5t($aRow->{$aColumns[$i]}).'/2" ><i class="fa fa-book"></i></a>
						&nbsp;&nbsp;|&nbsp;&nbsp;<a href="'.URL.'employee/viewsalarycertificate/'.Utils::encode5t($aRow->Id).'/2" rel="tooltip"  title="Expericence Certificate" target="_blank"><i class="fa fa-file-text-o"></i></a>';
					
						
					
				}
				else if($aColumns[$i]=="EmployeeCode")
				{
					$row[] = '<a href="'.URL.'employee/viewemployee/'.Utils::encode5t($aRow->Id).'/3">'.$aRow->{$aColumns[$i]}.'</a>';
					
				}
				elseif($aColumns[$i]=="EmployeeCTC"){	
					$divcur= Utils::getDivisioncurrency($aRow->Division,$this->db);
					$row[] = Utils::numberformatter($aRow->{$aColumns[$i]},$divcur);
				}
				elseif($aColumns[$i]=="DOB" || $aColumns[$i]=="DOC" || $aColumns[$i]=="DOJ" || $aColumns[$i]=="DOL"){											
					$row[] = Utils::dateformatter($aRow->{$aColumns[$i]});
				}
				elseif($aColumns[$i]=="Division" || $aColumns[$i]=="Department" || $aColumns[$i]=="Channel"|| $aColumns[$i]=="Designation" || $aColumns[$i]=="Grade" || $aColumns[$i]=="Shift" || $aColumns[$i]=="Nationality" || $aColumns[$i]=="Visa" || $aColumns[$i]=="Location"){
											
					$row[] =Utils::getName( $aRow->{$aColumns[$i]}, $aColumns[$i].'Master', "Name", $this->db);
				}
				elseif($aColumns[$i]=="CreatedDate" || $aColumns[$i]=="LastModifiedDate"){
					$row[] =Utils::datetimeformatter($aRow->{$aColumns[$i]});
				}
				elseif($aColumns[$i]=="ReportingTo" || $aColumns[$i]=="LastModifiedById" || $aColumns[$i]=="CreatedById"){											
					$row[] =Utils::getEmployeeName( $aRow->{$aColumns[$i]},$this->db);
				}
				elseif($aColumns[$i]=="FirstName"){	
					$row[] =Utils::getEmployeeName( $aRow->Id,$this->db);
				}
				elseif($aColumns[$i]=="CurrentContactNumber"){
					$row[] =Utils::decode5t($aRow->{$aColumns[$i]});
				}
				elseif($aColumns[$i]=="HomeEmailId"){
					$row[] =Utils::decode5t($aRow->{$aColumns[$i]});
				}
				
				elseif($aColumns[$i]=="Gender" || $aColumns[$i]=="MaritalStatus" || $aColumns[$i]=="EmploymentType"){
											
					$row[] =$this->getOtherMasterData( $aRow->{$aColumns[$i]}, $aColumns[$i]);
				}
				elseif($aColumns[$i]=="EmployeeStatus"){
											
					$row[] =Utils::getOtherName( $aRow->{$aColumns[$i]}, 'EmployeeStatus', $this->db);
				}
				else
				{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
	
	public function getConfirmDataTable()
	{
		
		$sTable = 'EmployeeMaster';
		$sIndexColumn = "Id";
		$userid = $_SESSION['ubihrm_user_id'];
		//$roleid = $_SESSION['ubihrm_user_roleid'];
		$aColumns = array('EmployeeCode', 'FirstName','ReportingTo', 'Division', 'Department', 'Channel','Designation', 'Nationality', 'DOJ', 'EmployeeCTC', 'Grade', 'EmployeeStatus', 'Id');
		
		//$roleid = $this->getRoleIds($roleid); 'CreatedById', 'CreatedDate', 'LastModifiedById', 'LastModifiedDate',
		
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY DOJ, ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		
		$orgid=$_SESSION['ubihrm_org_id'];
		$sts=$_SESSION['ubihrm_user_sts'];
		
		$sWhere = "";
		$hrsts=$_SESSION['ubihrm_hr_sts'];
			
		if($sts==1 || $hrsts==1){
			$sWhere = " WHERE  OrganizationId= $orgid and (DOL='0000-00-00') and ProvisionPeriod <>0  and Date_sub(curdate(),  interval -1 day) BETWEEN DOJ AND DATE_ADD(DOJ, INTERVAL ProvisionPeriod month) ";
		}else{
			$ids = Utils::getReportingIds($userid, $this->db);
			$sWhere = " WHERE (Id in ($ids) AND OrganizationId= $orgid) and (DOL='0000-00-00') and ProvisionPeriod <>0  and Date_sub(curdate(),  interval -1 day) BETWEEN DOJ AND DATE_ADD(DOJ, INTERVAL ProvisionPeriod month) ";
		}
		
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " AND (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id"){
				continue;
				}
				if($aColumns[$i]=="FirstName"){
					$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR  MiddleName LIKE '%".( $_GET['sSearch'] )."%' OR  LastName LIKE '%".( $_GET['sSearch'] )."%' OR ";
				}else{
					$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
				}
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		$flg=false;
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				
				if($aColumns[$i]=="DOL"){
					$flg=true;
					$sWhere .= $aColumns[$i]."  ".($_GET['sSearch_'.$i])." '0000-00-00' ";
				}else{
					$sWhere .= $aColumns[$i]." = '".($_GET['sSearch_'.$i])."' ";
				}
			}
		}
		if(!$flg){
			$sWhere .= " and (DOL='0000-00-00')";
		}
		
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		
		
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id")
				{
					$edit =""; $delete="";
					$row[] = '<a rel="tooltip" title="Require Confirmation" href="'.URL.'employee/viewconfirmemployee/'.Utils::encode5t($aRow->{$aColumns[$i]}).'" ><i class="fa fa-edit"></i></a>';
					/*	$edit1 = '<a rel="tooltip" title="History" href="'.URL.'employee/timeline/'.Utils::encode5t($aRow->{$aColumns[$i]}).'/2" ><i class="fa fa-book"></i></a>';
						
						$hierchy = '<a rel="tooltip" title="Hierarchy" href="'.URL.'employee/hierarchy/'.Utils::encode5t($aRow->{$aColumns[$i]}).'/2" ><i class="fa fa-sitemap"></i></a>';
					$row[] =$edit1."&nbsp;|&nbsp;".$hierchy;*/
				}
				else if($aColumns[$i]=="EmployeeCode")
				{
					$row[] = '<a href="'.URL.'employee/viewemployee/'.Utils::encode5t($aRow->Id).'/4">'.$aRow->{$aColumns[$i]}.'</a>';
					
				}
				elseif($aColumns[$i]=="EmployeeCTC"){											
					$divcur= Utils::getDivisioncurrency($aRow->Division,$this->db);
					$row[] = Utils::numberformatter($aRow->{$aColumns[$i]},$divcur);
				}
				elseif($aColumns[$i]=="DOB" || $aColumns[$i]=="DOC" || $aColumns[$i]=="DOJ" || $aColumns[$i]=="DOL"){											
					$row[] = Utils::dateformatter($aRow->{$aColumns[$i]});
				}
				elseif($aColumns[$i]=="Division" || $aColumns[$i]=="Department"|| $aColumns[$i]=="Channel" || $aColumns[$i]=="Designation" || $aColumns[$i]=="Grade" || $aColumns[$i]=="Shift" || $aColumns[$i]=="Nationality" || $aColumns[$i]=="Visa" || $aColumns[$i]=="Location"){
											
					$row[] =Utils::getName( $aRow->{$aColumns[$i]}, $aColumns[$i].'Master', "Name", $this->db);
				}
				elseif($aColumns[$i]=="CreatedDate" || $aColumns[$i]=="LastModifiedDate"){
					$row[] =Utils::datetimeformatter($aRow->{$aColumns[$i]});
				}
				elseif($aColumns[$i]=="ReportingTo" || $aColumns[$i]=="LastModifiedById" || $aColumns[$i]=="CreatedById"){											
					$row[] =Utils::getEmployeeName( $aRow->{$aColumns[$i]},$this->db);
				}
				elseif($aColumns[$i]=="FirstName"){											
					$row[] =Utils::getEmployeeName( $aRow->Id,$this->db);
				}
				elseif($aColumns[$i]=="Gender" || $aColumns[$i]=="MaritalStatus" || $aColumns[$i]=="EmploymentType"){
											
					$row[] =$this->getOtherMasterData( $aRow->{$aColumns[$i]}, $aColumns[$i]);
				}
				elseif($aColumns[$i]=="EmployeeStatus"){
											
					$row[] =Utils::getOtherName( $aRow->{$aColumns[$i]}, 'EmployeeStatus', $this->db);
				}
				elseif($aColumns[$i]=="ProvisionPeriod"){
					$days=	$this->getprobationdays( $aRow->Id);
					if($days>0)					
					$row[] =$days;
					else
					$row[] =0;
				}
				else
				{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
	
	
	
	public function getGratuityDataTable($arr)
	{
		
		$sTable = 'EmployeeMaster';
		$sIndexColumn = "Id";
		$userid = $arr[0];
		//echo $arr[2];
		$endate =$arr[2];
		//$roleid = $_SESSION['ubihrm_user_roleid'];
		$aColumns = array('EmployeeCode', 'FirstName','Division','Department','Channel','Designation', 'Grade', 'DOJ', 'EmployeeCTC', 'EmployeeCTC', 'CurrentEmailId','Id');
		
		//$roleid = $this->getRoleIds($roleid);
		
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY  ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		
		$orgid=$arr[1];
		$sts=$_SESSION['ubihrm_user_sts'];
		$ids = Utils::getReportingIds($userid, $this->db);
		$sWhere = "";
		$hrsts=$_SESSION['ubihrm_hr_sts'];
			
		if($sts==1 || $hrsts==1){
			$sWhere = " WHERE  OrganizationId= $orgid and (DOL='0000-00-00' or DOL>curdate())";
		}else{
			$sWhere = " WHERE Id in ($ids) AND OrganizationId= $orgid and (DOL='0000-00-00' or DOL>curdate()) ";
		}
		
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " AND (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id"){
				continue;
				}
				if($aColumns[$i]=="Grade"){
					$sWhere .= "(Grade in (select Id from GradeMaster where Name "." LIKE '%".( $_GET['sSearch'] )."%')) OR ";
				}
				elseif($aColumns[$i]=="CurrentEmailId"){
					$sWhere .= $aColumns[$i]." LIKE '%".Utils::encode5t( $_GET['sSearch'] )."%' OR ";
				}else{
					$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
				}
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
			}
		}
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		//$rResult = query($sQuery);// or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		
		
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id" ){	
				
					$divcur= Utils::getDivisioncurrency($aRow->Division,$this->db);
					$row[] = Utils::numberformatter( Utils::getEmployeeGratuity( $aRow->Id, 1, $this->db,$endate),$divcur);
				}elseif( $aColumns[$i]=="CurrentEmailId"){
					$divcur= Utils::getDivisioncurrency($aRow->Division,$this->db);
					$row[] = Utils::numberformatter( Utils::getEmployeeGratuity( $aRow->Id, 2, $this->db,$endate),$divcur);
				}
				elseif($aColumns[$i]=="Division" || $aColumns[$i]=="Department" || $aColumns[$i]=="Designation" || $aColumns[$i]=="Grade" || $aColumns[$i]=="Shift" || $aColumns[$i]=="Nationality" || $aColumns[$i]=="Visa" || $aColumns[$i]=="Channel"){
											
					$row[] =Utils::getName( $aRow->{$aColumns[$i]}, $aColumns[$i].'Master', "Name", $this->db);
				}
				elseif($aColumns[$i]=="FirstName"){
											
					$row[] =Utils::getEmployeeName( $aRow->Id, $this->db);
				}
				elseif($aColumns[$i]=="DOJ"){
					$row[] = Utils::dateformatter($aRow->{$aColumns[$i]});
				}elseif($aColumns[$i]=="EmployeeCTC" && $i==8){
					$divcur= Utils::getDivisioncurrency($aRow->Division,$this->db);
					$row[] = Utils::numberformatter(Utils::getEmployeeBasicSalary($aRow->Id, $this->db),$divcur);
					//$row[] = Utils::numberformatter($aRow->{$aColumns[$i]},$divcur);
				}
				elseif($aColumns[$i]=="EmployeeCTC" && $i==9){
					$divcur= Utils::getDivisioncurrency($aRow->Division,$this->db);
					//$row[] = Utils::numberformatter(Utils::getEmployeeBasicSalary($aRow->Id, $this->db),$divcur);
					$row[] = Utils::numberformatter($aRow->{$aColumns[$i]},$divcur);
				}
				else
				{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
	
	
	//////////////////////////////uploading image/////////////////////////////
	public function uploadImage($request)
	{
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$empid = $request[2];
		$empcode=$this->getCode($empid);
		$new_name="";
		$dir="public/uploads/$orgid";
		
		if (! is_dir($dir)) {
			mkdir($dir);
			chmod($dir,0755);
			
		}
		
		//$dir="public/uploads/$orgid";
		$filename="";
		
			if(isset($_FILES['file0'])){
				$errors= array();
				$file_name = $_FILES['file0']['name'];
				$ext = pathinfo($file_name, PATHINFO_EXTENSION);
				if ($ext=='png' || $ext=='PNG' || $ext=='jpg' || $ext=='JPG' || $ext=='gif' || $ext=='GIF' || $ext=='MOV' || $ext=='tif' || $ext=='TIF' || $ext=='jpeg' || $ext=='ico') 
				{
					if (is_dir($dir)) {
						if ($dh = opendir($dir)) {
							while (($file = readdir($dh)) != false) {
								$filename=$file;
								$ext1 = end((explode(".", $filename)));
								if($filename=="$empcode.$ext1")
								{
									unlink("public/uploads/$orgid/$filename");
								}
							}
						closedir($dh);
						}
					}
					$new_name="$empcode.$ext";
					$file_size =$_FILES['file0']['size'];
					$file_tmp =$_FILES['file0']['tmp_name'];
					$file_type=$_FILES['file0']['type'];   
					$location="public/uploads/$orgid/";
					if($file_size > 2097152){
					$errors[]='File size must be less than 2 MB';
					
					}	
					
					if(empty($errors)==true){
					
						$sts=move_uploaded_file($file_tmp, $location.$new_name);
						if($sts){
							//////////////updating path of employee profile picture in database/////////////
			
								$sql = "UPDATE EmployeeMaster SET  ImageName=? where Id=?";	
								$query = $this->db->prepare($sql);
							
								try{
									$query->execute(array($new_name,$empid ));			
									$count =  $query->rowCount();
								}catch(Exception $e) {
									$errorMsg = 'Message: ' .$e->getMessage();
								}
								 $status =true;
								 $successMsg = EMPLOYEE_MODULE_PROFILEIMAGE;
						}
					}
					else{
					$status =false;
					$errorMsg = 'File size must be less than 2 MB';
					}
				}
				else{
					$status =false;
					$successMsg = EMPLOYEE_MODULE_IMAGEIMPORT;
				}				
			}		
				$result["data"] =$data;
				$result['status']=$status;
				$result['successMsg']=$successMsg;
				$result['errorMsg']=$errorMsg;
				// default return
				return $result;
	
	}
	/*public function deletedoc($path) {
        if (is_dir($path)) {
            array_map(function($value) {
                $this->deletedoc($value);
                rmdir($value);
            },glob($path . '/*', GLOB_ONLYDIR));
            array_map('unlink', glob($path."/*"));
        }
		//rmdir($path);
    }*/
	//////////////////////////////uploading document/////////////////////////////
	public function uploadDocument($request)
	{
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$empid = $request[2];
		$docid = isset($_POST['doc_id'])?$_POST['doc_id']:0;
		
		$doctype = $request[4];
		$empcode=$this->getCode($empid);
		
		$new_name="";
		//$this->deletedoc("public/uploads/$orgid/2SD" );
		$dir="public/uploads/$orgid/$empcode";
		
		if (! is_dir($dir)) {
			mkdir($dir);
			chmod($dir,0755);
			}
		
		$filename="";
			if(isset($_FILES)){
			$con=count($_FILES);	
			for($i=0;$i<$con;$i++){
				if(isset($_FILES['file'.$i])){
				if($doctype == 1 ){
					$sql = "SELECT Id FROM EmployeeDocument where EmployeeId=? and DocumentTypeId=?";
					$query = $this->db->prepare($sql);
					$query->execute(array($empid,$_POST['doc_id'.$i]));
					while($row=$query->fetch())
					{
						$docid=$row->Id;
					}
				
				}
				$doc1="$empcode".'_'."$docid";
		
				$errors= array();
				$file_name = $_FILES['file'.$i]['name'];
				$ext = pathinfo($file_name, PATHINFO_EXTENSION);
				if ($ext=='png' || $ext=='PNG' || $ext=='jpg' || $ext=='JPG' || $ext=='gif' || $ext=='GIF' || $ext=='MOV' || $ext=='tif' || $ext=='TIF' || $ext=='jpeg' || $ext=='ico'){ 
					
				
					if (is_dir($dir)) {
						if ($dh = opendir($dir)) {
							while (($file = readdir($dh)) != false) {
								$filename=$file;
								$ext1 = end((explode(".", $filename)));
								if($filename=="$doc1.$ext1")
								{
									unlink("public/uploads/$orgid/$empcode/$filename");
								}
							}
						closedir($dh);
						}
					}
					$new_name="$empcode".'_'."$docid.$ext";
					
					$file_size =$_FILES['file'.$i]['size'];
					$file_tmp =$_FILES['file'.$i]['tmp_name'];
					$file_type=$_FILES['file'.$i]['type'];   
					$location="public/uploads/$orgid/$empcode/";
					if($file_size > 2097152){
					$errors[]='File size must be less than 2 MB';
					}	
					
					if(empty($errors)==true){
					
						if(move_uploaded_file($file_tmp, $location.$new_name)){
						$count++; }
						
					}else{
						print_r($errors);
					}
					if ($count >= 1) {
						$status =true;
					    $successMsg = EMPLOYEE_MODULE_DOCUPLOAD;
						if($doctype==2 ){
							$sql="Update EmployeeLTADetail set VisaAttachment=? where EmployeeId=? And EmiratesId =? ";
							$query=$this->db->prepare($sql);
							$query->execute(array($new_name,$empid,$docid));
						}
						if( $doctype==3){
							$sql="Update EmployeeLTADetail set PassportAttachment=? where EmployeeId=? And PassportNo =? ";
							$query=$this->db->prepare($sql);
							$query->execute(array($new_name,$empid,$docid));
						}
					   
					} else {
					   $status =false;
					   $errorMsg = EMPLOYEE_MODULE_DOCUPLOAD_FAILED;
					}
				}else {
				   $status =false;
				   $errorMsg = EMPLOYEE_MODULE_IMAGEIMPORT;
				}
				}else{
					$con++;
				}
			}
			}else{
				$status =false;
				   $errorMsg = EMPLOYEE_MODULE_IMAGEIMPORT;
			}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
        // default return
        return $result;
	
	}
	
	
	
	///////////////////////////////////////////////////////
	public function getNewEmployeeDataTable($editper, $deleteper)
	{
		$sTable = 'EmployeeNewJoinee';
		$sIndexColumn = "Id";
		$aColumns = array('Id', 'UpdateSts', 'FirstName', 'CurrentContactNumber', 'CurrentEmailId', 'OnboardSts', 'CreatedDate', 'UpdateSts');
		
		$sLimit = "";
		if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
		{
			$sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".( $_GET['iDisplayLength'] );
		}
		/*
		 * Ordering
		 */
		if ( isset( $_GET['iSortCol_0'] ) )
		{
			$sOrder = "ORDER BY  ";
			for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
			{
				if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
				{
					$sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
						".( $_GET['sSortDir_'.$i] ) .", ";
				}
			}
			
			$sOrder = substr_replace( $sOrder, "", -2 );
			if ( $sOrder == "ORDER BY" )
			{
				$sOrder = "";
			}
		}
		$orgid=$_SESSION['ubihrm_org_id'];
		$sWhere = " WHERE  OrganizationId= $orgid ";
		//$sWhere = "";
		if ( $_GET['sSearch'] != "" )
		{
			$sWhere .= " AND (";
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="Id"){
				continue;
				}
				elseif($aColumns[$i]=="CurrentEmailId" || $aColumns[$i]=="CurrentContactNumber"){
					$sWhere .= $aColumns[$i]." LIKE '%".Utils::encode5t( $_GET['sSearch'] )."%' OR ";
				}
				$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
			}
			$sWhere = substr_replace( $sWhere, "", -3 );
			$sWhere .= ')';
		}
		
		/* Individual column filtering */
		for ( $i=0 ; $i<count($aColumns) ; $i++ )
		{
			if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
			{
				if ( $sWhere == "" )
				{
					$sWhere = "WHERE ";
				}
				else
				{
					$sWhere .= " AND ";
				}
				$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
			}
		}
		
		$sQuery = "
		SELECT SQL_CALC_FOUND_ROWS ".str_replace(" , ", " ", implode(", ", $aColumns))."
		FROM   $sTable
		$sWhere
		$sOrder
		$sLimit
		";
		
		//$rResult = query($sQuery); or die(mysql_error());
		$query = $this->db->prepare($sQuery);
		$query->execute();
		/* Data set length after filtering */
		$sQuery = "
			SELECT FOUND_ROWS() as rowcount
		";
		/*$rResultFilterTotal = query( $sQuery);
		$aResultFilterTotal = fetch($rResultFilterTotal);
		$iFilteredTotal = $aResultFilterTotal[0];*/
		
		$query1 = $this->db->prepare($sQuery);
		$query1->execute();
		$row = $query1->fetch();
		$iFilteredTotal = $row->rowcount;
		/*
		 * Output
		 */
		$output = array(
			"sEcho" => intval($_GET['sEcho']),
			"iTotalRecords" => $iFilteredTotal,
			"iTotalDisplayRecords" => $iFilteredTotal,
			"aaData" => array()
		);
		$index=0;
		
		
		while ( $aRow =  $query->fetch() )
		{
			$row = array();
			for ( $i=0 ; $i<count($aColumns) ; $i++ )
			{
				if($aColumns[$i]=="CreatedDate"){
											
					$row[] = Utils::datetimeformatter($aRow->{$aColumns[$i]});
				}				
				else if($aColumns[$i]=="OnboardSts"){
											
					if(($aRow->{$aColumns[$i]})==1){
						$row[] = "<span class='label label-success'>Ubirecruit Import</span>";
					}
					elseif(($aRow->{$aColumns[$i]})==2){
						$row[] = "<span class='label label-warning'>CSV Import</span>";
					}else{
						$row[] = "-";
					}
				}
				
				else if($aColumns[$i]=="UpdateSts" && $i>2)
				{
					$edit =""; $delete="";
					if($editper){
						if( $aRow->{$aColumns[$i]}==1 ){
							$edit = '<a rel="tooltip" title="waiting for employee to update the details" ><i class="fa fa-user"></i></a>';
						}else{
							$edit = '<a rel="tooltip" title="Add Company Details" href="'.URL.'employee/onboard_company_details/'.Utils::encode5t($aRow->Id).'" ><i class="fa fa-edit"></i></a>';
						}
					}
					else{
						$edit = '<a href="#" rel="tooltip" title="No permission to edit"><i class="fa fa-edit"></i></a>';
					}					
					if($deleteper){
						$delete ='<a data-href="'.URL.'employee/deletenewemployee/'.$aRow->Id.'" data-toggle="modal" data-target="#confirm" rel="tooltip" href="#" title="Delete"><i class="fa fa-trash"></i></a>';
					}else{
						$delete = '<a href="#" rel="tooltip" title="No permission to delete"><i class="fa fa-trash"></i></a>';
					}
									
					$row[] = $edit."&nbsp;&nbsp; | &nbsp;&nbsp;".$delete;
				}
				else if($aColumns[$i]=="FirstName")
				{
					$row[] =Utils::getName($aRow->Id,'EmployeeNewJoinee','FirstName',$this->db)." ".Utils::getName($aRow->Id,'EmployeeNewJoinee','LastName',$this->db);
				}
				else if($aColumns[$i]=="CurrentContactNumber" || $aColumns[$i]=="CurrentEmailId")
				{
					$row[] =Utils::decode5t($aRow->{$aColumns[$i]});
				}
				else{
					$row[] = $aRow->{$aColumns[$i]};
				}
			}			
			$output['aaData'][] = $row;
		}		
		return  $output ;
	}
	
	public function getFileHeaders($request)
	{
			try {
			$result = array();
			$count=0; $errorMsg=""; $successMsg=""; $status=false;
			$data = array();
			$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
			$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
			$file_name = "";
			
			if(isset($_FILES['file0'])){
				$errors= array();
				$file_name = $_FILES['file0']['name'];
				$ext = pathinfo($file_name, PATHINFO_EXTENSION); 
				
				$storage_name="newjoining.$ext";
					if (!file_exists("public/uploads/$orgid/")) {
						mkdir("public/uploads/$orgid/", 0777, true);
						}
				if (file_exists($storage_name))
				{ unlink("public/uploads/$orgid/$storage_name"); 
				}

				$file_size =$_FILES['file0']['size'];
				$file_tmp =$_FILES['file0']['tmp_name'];
				$file_type=$_FILES['file0']['type'];   
				$location="public/uploads/$orgid/";
				if($file_size > 2097152){
				$errors[]='File size must be less than 2 MB';
				}	
				
				if(empty($errors)==true){
				
					move_uploaded_file($file_tmp, $location.$storage_name );
					
				}else{
					print_r($errors);
				}
			}		
		//$actual_date = "candidate_details_".$_REQUEST['org_id'];
		//$org_id = isset($_REQUEST['org_id']) ? $_REQUEST['org_id'] : '';
		//$fileName=isset ($_REQUEST['fileName'])	? $_REQUEST['fileName'] : '';
		$ext = pathinfo($file_name, PATHINFO_EXTENSION);
		if ($ext=='csv'){
		
			$fp = $location.$storage_name;
			
		
			if (($handle = fopen($fp, "r")) !== FALSE) 
			{
				$row = 1;
				$ind=1;
				$arrData 		= array();
				while (($data = fgetcsv($handle, 5000, ",")) !== FALSE) 
				{
					
					if($row == 1)
					{
						for($i = 0 ; $i<count($data);$i++)
						{
							
							$record 	= array();				
							
							$record['head_name'] = $data[$i];
							
							$record['rows'] = $count;
							$record['column_index'] = (int)$count;
							$record['sts'] = true;
							$count++;
							
							$arrData[] = $record;			
						}
									
						$row++;
						
					}
				}
				
				
				if ($count >= 1) {
				   $status =true;
				   
				} 
				else {
				   $status =false;
				   $errorMsg = EMPLOYEE_MODULE_CREATION_FAILED;
				}
				$result["data"] =$arrData;
				$result['status']=$status;
				$result['successMsg']=$successMsg;
				$result['errorMsg']=$errorMsg;
				return $result;
			}
		} 
		else if (strpos('xls',$ext)!==false || strpos('xlsx',$ext)!==false){
			require_once  LIBS_PATH.'ExcelClasses/PHPExcel/IOFactory.php';
			
			if ($ext=='xls'){
				$objReader = PHPExcel_IOFactory::createReader('Excel5');
			}else if($ext=='xlsx'){
				$objReader = PHPExcel_IOFactory::createReader('Excel2007');
			}
			 $objReader->setReadDataOnly(true); $objPHPExcel = $objReader->load($location.$file_name.".".$ext);
			 $objWorksheet = $objPHPExcel->getActiveSheet(); 
			 foreach ($objWorksheet->getRowIterator() as $row) 
			 {
				 $cellIterator = $row->getCellIterator(); 
				 $cellIterator->setIterateOnlyExistingCells(false); 
				 $count = 0;
					$record 						= array();				
					$record['head_name'] = "None";
					$record['name'] = '';
					$record['type'] = '';
					$record['data_label'] = '';
					$record['rows'] = $count;
					$record['h_count'] = $count;
					$record['sts'] = true;
					$arrData[] = $record;
					
				 foreach ($cellIterator as $cell) 
				 {
					
					$record = array();				
							
					$record['head_name'] = $cell->getValue();
					$record['name'] = '';
					$record['type'] = '';
					$record['data_label'] = '';
					$record['rows'] = $count;
					$record['h_count'] = $count;
					$record['sts'] = true;
					$count++;
					$arrData[] = $record;
				 } 
				 
				  array_pop($arrData);
				 break;
			 }
				
				return $result;
		}
			}catch(Exception $e){
				Utils::Trace($e->getMessage());
			}
	}
	
	//////////////////////////////////
	
  public function insertFileHeaders($request)
    {
		$result = array();
		$count=0;   $errorMsg=""; $successMsg=""; $status=false;
		 $c=0; $c1=0;
		$data1 = array();
		$data2 = array();
        $mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$fname = $request[2];
		$lname = $request[3];
		$dob = $request[4];
		$nat = $request[5];
		$marital = $request[6];
		$religion = $request[7];
		$bloodgrp = $request[8];
		//$known_lang = $request[9];
		$doj = $request[9];
		$doc = $request[10];
		$gender = $request[11];
		$contact_no = $request[12];
		$email = $request[13];
		$address = $request[14];
		$city = $request[15];
		$country = $request[16];
		$zipcode = $request[17];
		$mname= $request[18];
		$empctc= $request[19];
		$file_name = "newjoining.csv";		
		$mdate = date("Y-m-d H:i:s");
		$location=URL."public/uploads/$orgid/";
		$fp = $location.$file_name;
			$i=0;	
			
				
			if (($handle = fopen($fp, "r")) !== FALSE) 
			{
			
				while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) 
				{
					
						
					if($i>0)
					{ 
							$sql = "SELECT * FROM EmployeeNewJoinee WHERE CurrentEmailId = ? AND CurrentContactNumber =?";
							$query = $this->db->prepare($sql);
							try{ 
							
								$query->execute(array(Utils::decode5t($data[$email]),Utils::decode5t($data[$contact_no])));
								
								
							}catch(Exception $e) {
								$errorMsg = 'Message: ' .$e->getMessage();
								
							}
							if (($query->rowcount())>0) {
							   
							   $status =true;
							   $c++;
								$errorMsg = EMPLOYEE_MODULE_UPDATION_DUPLICATE;
							}
							else{
								// SQL Query to insert data into DataBase
								$sql1 = "INSERT INTO EmployeeNewJoinee ( FirstName, LastName, DOB, Nationality, MaritalStatus, Religion, BloodGroup,  DOJ,   Gender, CurrentContactNumber, CurrentEmailId, CurrentAddress, CurrentCountry, CurrentCity, CurrentZipCode,  CreatedDate, MiddleName, EmployeeCTC,OrganizationId,UpdateSts,OnboardSts) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";		
								try{
									
									$query1 = $this->db->prepare($sql1);
									$query1->execute(array($data[$fname], $data[$lname],$data[$dob],$data[$nat],$data[$marital],$data[$religion],$data[$bloodgrp],$data[$doj],$data[$gender],Utils::encode5t($data[$contact_no]),Utils::encode5t($data[$email]),Utils::encode5t($data[$address]),$data[$country],$data[$city],$data[$zipcode],  $mdate, $data[$mname], $data[$empctc],$orgid,2,2));
								
									$count1 =  $query1->rowCount();		
								}catch(Exception $e) {
									$errorMsg .= 'Message: ' .$e->getMessage();
								}
								if ($count1 >= 1) {
								   $status =true;
								   
								   $c1++;
								   $successMsg = EMPLOYEE_MODULE_EMPIMPORT;
								} 
							}
						
					}							
						$i++;
				}
			}		
			
    if ($i == 1) {
		$status =false;
		$errorMsg = EMPLOYEE_MODULE_EMPIMPORT_FAIL;
		}  
		
		$result["repeatemp"] =$c;
		$result["importemp"] =$c1;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	public function importtabledata($request)
    {
		$result = array();
		$count=0;   $errorMsg=""; $successMsg=""; $status=false;
		 $c=0; $c1=0;
		$data1 = array();
		$data2 = array();
        $mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$fname = $request[2];
		$lname = $request[3];
		$dob = $request[4];
		$nat = $request[5];
		$marital = $request[6];
		$religion = $request[7];
		$bloodgrp = $request[8];
		$known_lang = $request[9];
		$doj = $request[10];
		$doc = $request[11];
		$gender = $request[12];
		$contact_no = $request[13];
		$email = $request[14];
		$address = $request[15];
		$city = $request[16];
		$country = $request[17];
		$zipcode = $request[18];
		$file_name = "newjoining.csv";		
		$mdate = date("Y-m-d H:i:s");
		$location=URL."public/uploads/$orgid/";
		$fp = $location.$file_name;
			$i=0;	
			
				
			if (($handle = fopen($fp, "r")) !== FALSE) 
			{
			
				while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) 
				{
					
						
					if($i>0)
					{ 
						
							
							$sql = "SELECT * FROM EmployeeNewJoinee WHERE CurrentEmailId = ? AND CurrentContactNumber =?";
							$query = $this->db->prepare($sql);
							try{ 
							
								$query->execute(array(Utils::encode5t($data[$email]),Utils::encode5t($data[$contact_no])));
								$count =  $query->rowCount();
								
							}catch(Exception $e) {
								$errorMsg = 'Message: ' .$e->getMessage();
								
							}
							if ($count >= 1) {
							   
							   $status =true;
							   $c++;
								
							   $errorMsg = EMPLOYEE_MODULE_UPDATION_DUPLICATE;
							}
							else{
								// SQL Query to insert data into DataBase
								$sql = "INSERT INTO EmployeeNewJoinee ( FirstName, LastName, DOB, Nationality, MaritalStatus, Religion, BloodGroup, KnownLanguage, DOJ,  Gender, CurrentContactNumber, CurrentEmailId, CurrentAddress, CurrentCountry, CurrentCity, CurrentZipCode,  CreatedDate,OrganizationId) VALUES (?, ?,  ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";		
								try{
									
									$query = $this->db->prepare($sql);
									$query->execute(array($data[$fname], $data[$lname],$data[$dob],$data[$nat],$data[$marital],$data[$religion],$data[$bloodgrp],$data[$known_lang],$data[$doj],$data[$gender],Utils::decode5t($data[$contact_no]),Utils::decode5t($data[$email]),Utils::decode5t($data[$address]),$data[$country],$data[$city],$data[$zipcode],  $mdate,$orgid));
								
									$count1 =  $query->rowCount();		
								}catch(Exception $e) {
									$errorMsg .= 'Message: ' .$e->getMessage();
								}
								if ($count1 >= 1) {
								   $status =true;
								   
								   $c1++;
								   $successMsg = EMPLOYEE_MODULE_EMPIMPORT;
								} 
							}
						
					}							
						$i++;
				}
			}		
			
    if ($i == 1) {
		$status =false;
		$errorMsg = EMPLOYEE_MODULE_EMPIMPORT_FAIL;
		}  
		
		$result["repeatemp"] =$c;
		$result["importemp"] =$c1;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
  
	public function employeecode()
	{
		
		$sql = "select Id, EmployeeCode, Division, DOJ from EmployeeMaster where OrganizationId=1 order by DOJ, Division";
		$query = $this->db->prepare($sql);
		$query->execute();
		while($row= $query->fetch())
		{
			$employeecode="";
			$sqldiv="SELECT Code FROM DivisionMaster WHERE Id =?";	
			$querydiv = $this->db->prepare($sqldiv);
			$querydiv->execute(array($row->Division));
					$divcode=0;									
				while($rowdiv = $querydiv->fetch()){
					$divcode=$rowdiv->Code;
								
					$yearofjoining=date("y", strtotime(date($row->DOJ)));
					
					$ecode=$divcode.$yearofjoining;	
					$employeecode=$this->CheckexistingEmpcode($ecode,1);
					
					$sql1="Update EmployeeMaster set EmployeeCode=? where Id=?";	
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array($employeecode, $row->Id));
					
					$sql1="Insert into  EmployeeSequence (Id, OrganizationId ) values(?,?)";	
					$query1 = $this->db->prepare($sql1);
					$query1->execute(array($employeecode, 1));
				}
					
		}
	}
  ////////////////create new joinings empolyee////////////////////////
  public function CheckexistingEmpcode($ecode,$orgid)
	{
		$empcode =0;
		$sql = "SELECT coalesce(MAX(Id), 0, MAX(Id)) as maxid FROM EmployeeSequence WHERE Id like '$ecode%' and OrganizationId=?";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array($orgid ));
			while( $row =  $query->fetch() )
			{
				if($row->maxid ==0){
					$empcode=$ecode."01";
				}
				else{
					$empcode=($row->maxid)+1;
				}
			}
			
		}catch(Exception $e) {
			
		}
		return $empcode;
	}
	public function getMaxEmpid($orgid)
	{
		$empcode =0;
		$sql = "SELECT MAX(Id) as maxid FROM EmployeeSequence WHERE  OrganizationId=?";
        $query = $this->db->prepare($sql);
		try{
			$query->execute(array($orgid ));
			while( $row =  $query->fetch() )
			{
				if($row->maxid ==0){
					$empcode="01";
				}
				else{
					$mid=($row->maxid)+1;
					$empcode="0".$mid;
				}
			}
			
		}catch(Exception $e) {
			
		}
		return $empcode;
	}
  public function CreateNew($request)
    {
		$result = array();
		$count=0; $count1=0; $count2=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
        
		$mdate = date("Y-m-d H:i:s");
		
		
		//$empcode = strtoupper(dechex(strtotime("now")));
		
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$empid="";	
		$eid=$request[12];	
		//$array = explode(',', $eid);
		$desig=$request[5];
		$fname=""; $lname=""; $dob=""; $nationality=""; $marital=""; $doj=""; $doc=""; $gender=""; 
		$religion = "";	$bloodgrp = "";	$known_lang = ""; $contact_no = "";	$address = ""; $city = "";	$country = "";	$zipcode = "";	$airport=""; $role=""; $empcode=""; $cmp_email="";
		
		$this->db->beginTransaction();
		$this->db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);//raise error, throw errors
		
		try{
					$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
					$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
					////////// generate employee code///////
					$sqldiv="SELECT Code FROM DivisionMaster WHERE Id =?";	
					$querydiv = $this->db->prepare($sqldiv);
					$querydiv->execute(array($request[3]));
														
					while($rowdiv = $querydiv->fetch()){
						$divcode=$rowdiv->Code;
					}
					$doj=Utils::getDateformat($request[14]);					
					$yearofjoining=date("y", strtotime(date($doj)));
					
					$ecode=$divcode.$yearofjoining;	
					$employeecode=$this->CheckexistingEmpcode($ecode,$request[1]);
					$maxid=$this->getMaxEmpid($orgid);
					$employeecode="E".$maxid;
					$sql="SELECT * FROM EmployeeNewJoinee WHERE Id IN ( $eid )";	
					$query = $this->db->prepare($sql);
					$query->execute();
														
					while($row = $query->fetch()){
						$newid=$row->Id;
						$fname = $row->FirstName;
						$lname = $row->LastName;
						$dob = $row->DOB;
						$nationality = $row->Nationality;
						$gender = $row->Gender;
						$marital = $row->MaritalStatus;
						$religion = $row->Religion;
						$bloodgrp = $row->BloodGroup;
						$known_lang = $row->KnownLanguage;
						$doj = $row->DOJ;
						$doc = $row->DOC;
						$contact_no = $row->CurrentContactNumber;
						$address = $row->CurrentAddress;
						$city = $row->CurrentCity;
						$country = $row->CurrentCountry;
						$zipcode = $row->CurrentZipCode;
						$email = $row->CurrentEmailId;
						$contact_no1 = $row->HomeContactNumber;
						$address1 = $row->HomeAddress;
						$city1 = $row->HomeCity;
						$country1 = $row->HomeCountry;
						$zipcode1 = $row->HomeZipCode;
						$email1 = $row->HomeEmailId;
						$contact_no2 = $row->EmergencyContactNumber;
						$address2 = $row->EmergencyAddress;
						$city2 = $row->EmergencyCity;
						$country2 = $row->EmergencyCountry;
						$zipcode2 = $row->EmergencyZipCode;
						$email2 = $row->EmergencyEmailId;
						$exp=$row->TotalExp;
						$airport = $row->NearestAirport;
						$image=$row->ImageName;
						
						$sql1 = "SELECT * FROM EmployeeMaster WHERE CurrentEmailId = ? ";
						$query1 = $this->db->prepare($sql1);
						$query1->execute(array($email ));
						$count1 =  $query1->rowCount();
													
							if ($count1 >= 1) {
							    
							   $status =true;
							   $errorMsg = EMPLOYEE_MODULE_UPDATION_DUPLICATE;
							   
							}
							else{
								/*$sqlmax = "select coalesce(Max(Id)+1,1) as maxid from EmployeeSequence";
								$querymax = $this->db->prepare($sqlmax);
								$querymax->execute();
								$maxrow = $querymax->fetch();*/
								$empid = "";
								
								
								//$cmp_domain=$this->getDomain($orgid);
								//$cmp_email=strtolower("$fname$lname@$cmp_domain");
								$sql2 = "INSERT INTO EmployeeMaster ( EmployeeCode, FirstName, LastName, DOB, Nationality, MaritalStatus, Religion, BloodGroup, KnownLanguage, DOJ, DOC,  Gender, CurrentContactNumber, CurrentEmailId, CurrentAddress, CurrentCountry, CurrentCity, CurrentZipCode,HomeContactNumber, HomeEmailId, HomeAddress, HomeCountry, HomeCity, HomeZipCode, EmergencyContactNumber, EmergencyEmailId, EmergencyAddress, EmergencyCountry, EmergencyCity, EmergencyZipCode,  ReportingTo, Division, Department, Designation, Location, Shift, EmployeeStatus, Grade, WorkingDays, EmployeeCTC, EmploymentType, CompanyEmail, NearestAirport,  OrganizationId,  LastModifiedDate, LastModifiedById, CreatedDate, CreatedById, OwnerId, ImageName,TotalExp,ProvisionPeriod ) VALUES (?, ?, ?, ?,  ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,  ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? , ? , ?)";
								$query2 = $this->db->prepare($sql2);
								$query2->execute(array( $employeecode,$fname,$lname,$dob,$nationality,$marital,$religion,$bloodgrp,$known_lang,Utils::getDateformat($request[14]),$doc,$gender,$contact_no,$email,$address,$country,$city,$zipcode,$contact_no1,$email1,$address1,$country1,$city1,$zipcode1,$contact_no2,$email2,$address2,$country2,$city2,$zipcode2,$request[2],$request[3],$request[4],$request[5],$request[6],$request[7],$request[8],$request[9],$request[10],$request[11],$request[13],$cmp_email,$airport,$orgid, $mdate, $mid, $mdate, $mid, $mid,$image,$exp,$request[16]));
								
								$empid=$this->db->lastInsertId();
								
									$srcPath = "public/uploads/newjoining/";
									$destPath = "public/uploads/$orgid/";  
										
									$srcDir = opendir($srcPath);
									while($readFile = readdir($srcDir))
										{
											if($readFile == $image)
											{
												copy($srcPath.$readFile, $destPath.$readFile);
											}
										}
									closedir($srcDir); 	
									
								$sqldoc="SELECT * FROM EmployeeNewJoiningDocument WHERE EmployeeId =$newid";	
								$querydoc = $this->db->prepare($sqldoc);
								$querydoc->execute();
									while($row = $querydoc->fetch())
										{
											$id=$row->Id;					
											//$eid=$row->EmployeeId;
											$doctype = $row->DocumentTypeId;
											$docnum = $row->DocumentNumber;
											$issue = $row->IssuedOn;
											$expire = $row->ExpiredOn;
											
												$sql1="INSERT INTO EmployeeDocument (EmployeeId, DocumentTypeId, DocumentNumber, IssuedOn ,ExpiredOn, CreatedDate, CreatedById, LastModifiedDate, LastModifiedById, OwnerId, OrganizationId) values(?,?,?,?,?,?,?,?,?,?,?)";
												$query1 = $this->db->prepare($sql1);
												$query1->execute(array($empid,$doctype,$docnum,$issue,$expire,$mdate,$mid,$mdate,$mid,$mid,$mid));
												$c1=$query1->rowCount();
												$docid=$this->getdoc($empid);
												$image="$empcode".'_'."$id";
												
												if (!file_exists("public/uploads/$orgid/$empcode" ))
												{
													mkdir("public/uploads/$orgid/$empcode" ,  0755,true);
												}
												$srcPath = "public/uploads/newjoining/";
												$destPath = "public/uploads/$orgid/$empcode/";  
												$srcDir = opendir($srcPath);
												while($readFile = readdir($srcDir))
													{
														$ext = pathinfo($readFile, PATHINFO_EXTENSION);
														if($readFile == "$image.$ext")
														{
															$image1="$empcode".'_'."$docid.$ext";
															copy($srcPath.$readFile, $destPath.$readFile);
															//rename($destPath.$readFile,$destPath.$image1);
															
														}
													}
												closedir($srcDir);
												$destDir = opendir($destPath);
												while($readFile = readdir($destDir))
													{
														$ext = pathinfo($readFile, PATHINFO_EXTENSION);
														if($readFile == "$image.$ext")
														{
															$image1="$empcode".'_'."$docid.$ext";
															rename($destPath.$readFile,$destPath.$image1);
															
														}
													}
												closedir($destDir);
											
										}
										
									
									///////////////new joinee qualifications//////////////
									
									$sqlqul="SELECT * FROM EmployeeNewJoiningQualification WHERE EmployeeId =$newid";	
									$queryqul = $this->db->prepare($sqlqul);
									$queryqul->execute();
									while($row = $queryqul->fetch())
										{
											$id=$row->Id;
											//$eid=$row->EmployeeId;
											$institute = $row->InstituteName;
											$degree = $row->Degree;
											$fos = $row->FOS;
											$doc = $row->DOC;
											$gpa = $row->GPA;
											
											$sql1="INSERT INTO EmployeeQualification (EmployeeId, InstituteName, Degree, FOS ,DOC, GPA, CreatedById, LastModifiedDate, LastModifiedById, OwnerId, OrganizationId) values(?,?,?,?,?,?,?,?,?,?,?)";
											$query1 = $this->db->prepare($sql1);
											$query1->execute(array($empid,$institute,$degree,$fos,$doc,$gpa,$mid,$mdate,$mid,$mid,$mid));
										}
																
									
									
									///////////////new joinee referances/////////////
									
									$sqlref="SELECT * FROM EmployeeNewJoiningReference WHERE EmployeeId =$newid";	
									$queryref = $this->db->prepare($sqlref);
									$queryref->execute();
									while($row = $queryref->fetch())
										{
											$id=$row->Id;					
											//$eid=$row->EmployeeId;
											$name = $row->Name;
											$cmp = $row->Company;
											$email = $row->Email;
											$contact = $row->Contact;
											$sql1="INSERT INTO EmployeeReference (EmployeeId, Name, Company, Email ,Contact) values(?,?,?,?,?)";
											$query1 = $this->db->prepare($sql1);
											$query1->execute(array($empid,$name,$cmp,$email,$contact));
										}
																
									
									
									///////////////new joinee skills//////////////
									
									$sqlskill="SELECT * FROM EmployeeNewJoiningSkills WHERE EmployeeId =$newid";	
									$queryskill = $this->db->prepare($sqlskill);
									$queryskill->execute();
									while($row = $queryskill->fetch())
										{
											$id=$row->Id;
											//$eid=$row->EmployeeId;
											$skill = $row->SkillsId;
											$desc = $row->Description;
											$sql1="INSERT INTO EmployeeSkills (EmployeeId, SkillsId, Description) values(?,?,?)";
											$query1 = $this->db->prepare($sql1);
											$query1->execute(array($empid,$skill,$desc));
										}
																
									
									
									///////////////new joinee work experience/////////////
									
									$sqlexp="SELECT * FROM EmployeeNewJoiningWorkExperience WHERE EmployeeId =$newid";	
									$queryexp = $this->db->prepare($sqlexp);
									$queryexp->execute();
									while($row = $queryexp->fetch())
										{	
											$id=$row->Id;
											//$eid=$row->EmployeeId;
											$cmp = $row->CompanyName;
											$desig = $row->Designation;
											$from = $row->FromDate;
											$to = $row->ToDate;
											$desc = $row->Description;
											$sql1="INSERT INTO EmployeeWorkExperience ( EmployeeId, CompanyName, Designation, FromDate, ToDate, Description, CreatedDate, CreatedById, LastModifiedDate, LastModifiedById, OwnerId, OrganizationId) values(?,?,?,?,?,?,?,?,?,?,?,?)";
											$query1 = $this->db->prepare($sql1);
											$query1->execute(array($empid,$cmp,$desig,$from,$to,$desc,$mdate,$mid,$mdate,$mid,$mid,$mid));
										}
										
										// INSERTING AND UPDATING FamilyDetail OF EMPLOYEE IF PASSED AS AN JSON
									$checklistarr = json_decode($_POST['checklist'], true); 
			
										for($i=0; $i<count($checklistarr); $i++)
										{
											if($checklistarr[$i]['name']!="" && $checklistarr[$i]['categoryid']!="" ){
												$record = array();
												$record[0] = $empid;
												$record[1] = $checklistarr[$i]['name'];
												$record[2] = $checklistarr[$i]['sts'];
												$record[3] = $checklistarr[$i]['categoryid'];
												$record[4] = $checklistarr[$i]['checklistid'];
												
																
												
												$sqlwork = " INSERT INTO EmployeeChecklist ( EmployeeId, Name, Sts, CategoryId,ChecklistId) values (?,?,?,?,?)";
												$querywork = $this->db->prepare($sqlwork);
												$querywork->execute($record);
												
											}
										}										
												// INSERTING EMPLOYEE SEQUENCE GENERATED TO KEEP SEPARATE OF NEXT EMPLOYEE ID 
										$sqlseq = "INSERT INTO EmployeeSequence (Id,OrganizationId) values(?,?)";
										$queryseq = $this->db->prepare($sqlseq);
										$queryseq->execute(array($maxid,$orgid));
										
										$count2 =  $query2->rowCount();	
										if ($count2 >= 1) {
		
											$sqldel = "DELETE FROM EmployeeNewJoinee WHERE  Id = :id ";
											$querydel = $this->db->prepare($sqldel);
											$querydel->execute(array(':id' => $newid));
											
											$sqldel = "DELETE FROM EmployeeNewJoiningDocument WHERE EmployeeId = :id ";
											$querydel = $this->db->prepare($sqldel);
											$querydel->execute(array(':id' => $newid));
											
											$sqldel = "DELETE FROM EmployeeNewJoiningQualification WHERE EmployeeId = :id ";
											$querydel = $this->db->prepare($sqldel);
											$querydel->execute(array(':id' => $newid));
											
											$sqldel = "DELETE FROM EmployeeNewJoiningReference WHERE EmployeeId = :id ";
											$querydel = $this->db->prepare($sqldel);
											$querydel->execute(array(':id' => $newid));
											
											$sqldel = "DELETE FROM EmployeeNewJoiningWorkExperience WHERE EmployeeId = :id ";
											$querydel = $this->db->prepare($sqldel);
											$querydel->execute(array(':id' => $newid));
											
											$sqldel = "DELETE FROM EmployeeNewJoiningSkills WHERE EmployeeId = :id ";
											$querydel = $this->db->prepare($sqldel);
											$querydel->execute(array(':id' => $newid));
											
										} 
										
								} 			
					}
				
				
				
			$this->db->commit();     
		}catch(PDOException $e)
		{
			$this->db->rollBack();
			$errorMsg .= 'Message: ' .$e->getMessage();
		}catch(Exception $e)
		{
			$this->db->rollBack();
			$errorMsg = 'Message: ' .$e->getMessage();
		}  						
				
		if ($count2 >= 1) {
			/*
				$sqlrole="SELECT * FROM UserMaster WHERE EmployeeId= :id OR Username= :name";
				$queryrole = $this->db->prepare($sqlrole);
				$queryrole->execute(array(':id' => $empid, ':name' => $cmp_email ));
				$con =  $queryrole->rowCount();	
				if($con>=1){
					$status =true;
					$successMsg = EMPLOYEE_MODULE_CREATION_SUCCESS;		
				}
				else{
				$rand=rand(1000000,10000000);
				$pwd=dechex($rand);
				$pwd=strtoupper($pwd);
									
				$sql1 = "INSERT INTO UserMaster (EmployeeId, Password, Username, RoleId, OrganizationId,  LastModifiedDate, LastModifiedById, CreatedDate, CreatedById, OwnerId) VALUES (?, ?, ?,  ?, ?, ?, ?, ?, ?, ? )";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array( $empid, Utils::encode5t( $pwd), $cmp_email, $desig, $orgid, $mdate, $mid, $mdate, $mid, $mid));
				
				
				}
				*/
				
				$title="Joining";
				$designame=Utils::getName($desig,'DesignationMaster','Name',$this->db);
				$msg="Joined the company on $request[14] as a $designame";
				$sql1 = "INSERT INTO EmployeeHistory ( EmployeeId, Title, EventDate, Message, OrganizationId) VALUES (?, ?, ?, ?, ? )";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array( $empid, $title, Utils::getDateformat($request[14]), $msg, $orgid));
				
				$status =true;
				$successMsg = EMPLOYEE_MODULE_CREATION_SUCCESS;
			} 
		elseif ($count1 >= 1) {
			$status =false;
			$errorMsg = EMPLOYEE_MODULE_UPDATION_DUPLICATE;
			}
		else {
				$status =false;
				$errorMsg = EMPLOYEE_MODULE_CREATION_FAILED;
			}		  
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }

	
	
	   /**
     * Get method for fetching the records of department
     * @return array an array with several objects (the results)
     */
    public function getAllColumnName($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$tablename = $request[2];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		
		if(count($tablename)>1)
		{
			for($i=0;$i<count($tablename);$i++)
			{
				$sql = "select Id,ModuleLabel from ModuleMaster where  ModuleName=? ";
				$query = $this->db->prepare($sql);
				$query->execute(array($tablename[$i]));
				$count =  $query->rowCount();
				if($count>=1)
				{
					$status=true;
					$successMsg=$count." record found";
					$index=0;
					if($row = $query->fetch())
					{
						
						$moduleid = $row->Id;
						$modulelabel = $row->ModuleLabel;
						$sql = "Select * from ModuleChild where  ModuleId=? And ColumnSts = 1 order by ColumnLabel ";
						$query = $this->db->prepare($sql);
						$query->execute(array($moduleid));
						while($row1 = $query->fetch())
						{	
							$res = array();
							$res['name']=$tablename[$i].'.'.$row1->ColumnName;
							$res['label']=$modulelabel.' - '.$row1->ColumnLabel;
							$res['type']=$row1->FieldType;
							$res['tablename']=$row1->TableName;
							$res['colindex']="";
							$data[] = $res;
						}
					}	
					}else{
						$status=true;
						$successMsg = EMPLOYEE_MODULE_GETALL;
					}
				
			
			}
		}
		else{
			$tablename = is_array($request[2]) ? implode(',',$request[2]): $request[2];
			$sql = "select Id from ModuleMaster where  ModuleName=? ";// and Field<>'OrganizationId' and Field<>'CreatedById' and Field<>'CreatedDate' and Field<>'LastModifiedDate' and Field<>'LastModifiedById' and Field<>'OwnerId'";
			$query = $this->db->prepare($sql);
			try{
				$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
				$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;			
				
				$query->execute(array($tablename));
				$count =  $query->rowCount();
			}catch(Exception $e) {
				$errorMsg = 'Message: ' .$e->getMessage();
			}
			if($count>=1)
			{
				$status=true;
				$successMsg=$count." record found";
				$index=0;
				if($row = $query->fetch())
				{
					
					$moduleid = $row->Id;
					$sql = "Select * from ModuleChild where  ModuleId=? And ColumnSts =1 order by ColumnLabel asc";
					$query = $this->db->prepare($sql);
					$query->execute(array($moduleid));
					while($row1 = $query->fetch())
					{	
						$res = array();
						$res['name']=$row1->ColumnName;
						$res['label']=$row1->ColumnLabel;
						$res['type']=$row1->FieldType;
						$res['tablename']=$row1->TableName;
						$res['colindex']="";
						$data[] = $res;
					}
				}	
			}else{
				$status=true;
				$successMsg = EMPLOYEE_MODULE_GETALL;
			}
			
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
	public function importfiledata($request)
    {
		$result = array();
		$count=array();   $errorMsg=""; $successMsg=""; $status=false;
		$data1 = array();
		$data2 = array();
        $mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$tablename = $request[2];	
		
		$postdata = json_decode($_POST['columnsdata'], true); 
		//print_r($postdata);
		$file_name = "newjoining.csv";		
		$mdate = date("Y-m-d H:i:s");
		$location=URL."public/uploads/$orgid/";
		$fp = $location.$file_name;
			$loop=0;	
			$sql =""; $query="";
			if (($handle = fopen($fp, "r")) !== FALSE) 
			{
				while (($data = fgetcsv($handle, 5000, ",")) !== FALSE) 
				{	
					if($loop>0){
						
					}
					/*if($loop==0)
					{ 
						$coldata = array();
						$index=0;
						$sql = "INSERT INTO $tablename ( ";
						for($i=0; $i<count($postdata); $i++)
						{
							//echo $postdata[$i]['name']." - ".$postdata[$i]['colindex']."<br>";
							if((!empty($postdata[$i]['colindex'])) || $postdata[$i]['colindex']=="0")
							{
								if($index==0){$sql .= $postdata[$i]['name']; 
								}else{$sql .= ", ".$postdata[$i]['name'];} 
								
								//$coldata[$index++] = $data[$postdata[$i]['colindex']];
								$index++;
							}else{
								if($postdata[$i]['name']=="OrganizationId"){
									
									if($index==0){$sql .= $postdata[$i]['name']; 
									}else{$sql .= ", ".$postdata[$i]['name'];} 
									//$coldata[$index++] =$orgid;
								$index++;
								}else if($postdata[$i]['name']=="LastModifiedDate" || $postdata[$i]['name']=="CreatedDate"){
									
									if($index==0){$sql .= $postdata[$i]['name']; 
									}else{$sql .= ", ".$postdata[$i]['name'];} 
									//$coldata[$index++] =$mdate;
								$index++;
								}else if($postdata[$i]['name']=="LastModifiedById" || $postdata[$i]['name']=="CreatedById" || $postdata[$i]['name']=="OwnerId"){
									
									if($index==0){$sql .= $postdata[$i]['name']; 
									}else{$sql .= ", ".$postdata[$i]['name'];} 
									//$coldata[$index++] =$mid;
								$index++;
								}
							}
						}
						
						$index=0;
						$sql = $sql .") VALUES (";
						for($i=0; $i<count($postdata); $i++)
						{
							if((!empty($postdata[$i]['colindex'])) || $postdata[$i]['colindex']=="0")
							{
								if($index==0){$sql .= "?"; 
								}else{$sql .= ", ?";} 
								$index++;
							}else{
								if($postdata[$i]['name']=="OrganizationId" || $postdata[$i]['name']=="LastModifiedDate" || $postdata[$i]['name']=="CreatedDate" || $postdata[$i]['name']=="LastModifiedById" || $postdata[$i]['name']=="CreatedById" || $postdata[$i]['name']=="OwnerId"){
									if($index==0){$sql .= "?"; 
									}else{$sql .= ", ?";}
									$index++;
								}
							}
						}
						$sql = $sql .")";
						//echo $sql;		
						$query = $this->db->prepare($sql);
					}elseif($loop<5){
						//echo $loop." - ".count($data)." - ".$data[0]."<br>";
						//print_r($data);
						$coldata = array();
						$index=0;
						for($i=0; $i<count($postdata); $i++)
						{
							if((!empty($postdata[$i]['colindex'])) || $postdata[$i]['colindex']=="0")
							{
								if($postdata[$i]['type']=="dat"){
									$coldata[$index++] = date("Y-m-d",strtotime(date($data[$postdata[$i]['colindex']])));
								}else{
									$coldata[$index++] = $data[$postdata[$i]['colindex']];
								}								
							}else{
								if($postdata[$i]['name']=="OrganizationId"){
									$coldata[$index++] =$orgid;
								}else if($postdata[$i]['name']=="LastModifiedDate" || $postdata[$i]['name']=="CreatedDate"){
									$coldata[$index++] =$mdate;
								}else if($postdata[$i]['name']=="LastModifiedById" || $postdata[$i]['name']=="CreatedById" || $postdata[$i]['name']=="OwnerId"){
									$coldata[$index++] =$mid;
								}
							}
						}
						try{
							$query->execute($coldata);		
							if($query->rowCount()>0){
								$count[] =  1;
							}
						}catch(Exception $e) {
							$errorMsg .= 'Message: ' .$e->getMessage();
						}
					}*/					
						++$loop;
				}
			}		
		if(count($count)>0)
		{
			$status = true;
			$successMsg =count($count)." ".EMPLOYEE_MODULE_INSERT;
		}else{
			$status = false;
			$errorMsg .= EMPLOYEE_MODULE_INSERT;
		}
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
        // default return
        return $result;
    }
	
	
	public function setdefaultbank($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		
        
		try{
						
			$sql = "UPDATE EmployeeBankDetails set Status = 0";
			$query = $this->db->prepare($sql);
			$query->execute();
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg = "update";
			$sql = "UPDATE EmployeeBankDetails set Status = 1 Where Id = ? AND EmployeeId = ?";
			$query = $this->db->prepare($sql);
			$query->execute(array($request[0],$request[1]));		
		}       
		else{
			$status=false;
			$successMsg = "not update";
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
	
	
	public function getAllNewEmployee($request)
    {
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		
		$sql = "SELECT * FROM EmployeeNewJoinee WHERE OrganizationId = :id  ";
		$query = $this->db->prepare($sql);
		try{
			$query->execute(array(':id' => $orgid ));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			while($row = $query->fetch())
			{
				$res = array();
				$res['id'] = (int)$row->Id;
				
				$res['sts'] = $row->UpdateSts;
				
				$data[] = $res;
			}
        }else{
			$status=true;
			$successMsg = EMPLOYEE_MODULE_GETALL;
		}
		
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
    }
	
	public function getEmployeeSalaryType($request)
	{
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$division = $request[2];	//EMPLOYEE ID CONTAINS IN ARRAY SECOND VALUE;
		$grade = $request[3];	
		$desig = $request[4];	
		$department = $request[5];	
		$exp = $request[6];
        $channel = $request[7];		
		
		$sql = "SELECT * FROM SalaryTypeMaster WHERE OrganizationId = ? and SalaryApply <= CURDATE() and DivisionId=? and DepartmentId=? and GradeId=?";
        $query = $this->db->prepare($sql);
		try{
			
			$query->execute(array($orgid,$division,$department,$grade));
			$count =  $query->rowCount();
		}catch(Exception $e) {
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		if($count>=1)
		{
			$status=true;
			$successMsg=$count." record found";
			
			
			while($row = $query->fetch())
			{
				$res=array();
				$res['salarytypeid']=$row->Id;	
				$res['heads'] = array();
				$sql1 = "SELECT * FROM SalaryTypeChild WHERE SalaryId = :id";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array(':id' => $row->Id ));
				while($row1 = $query1->fetch())
				{
					$res1 = array();
					$res1['salaryheadid'] = $row1->SalaryHeadId;
					$res1['percent'] = $row1->SalaryPercent;
					$res1['percenttype'] = $row1->IsPercent;
					$res['heads'][] = $res1;
				}
				$data[]=$res;
				
			}
				
        }else{
			$status=true;
			$successMsg = LEAVETYPE_MODULE_GETALL;
		}
		$result["data"] =$data;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
	}
	
	public function getEmployeeSalaryDetails1($request)
	{
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array(); $salaryamt=0; $salarytype=0;
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$empid = $request[2];	//EMPLOYEE ID CONTAINS IN ARRAY SECOND VALUE;
		$gradeid = $request[3];
		$salaryamt= $grossalary = $request[4];
		$incentive = $request[5];
		$experience = $request[6];
		$division = $request[7];
		$department = $request[8];
		$preexp = $request[9];
				
		$sql11 = "SELECT * FROM EmployeeSalaryDetails WHERE EmployeeId = ?  ";
		$query11 = $this->db->prepare($sql11);
		try{
			$query11->execute(array( $empid ));
			if($query11->rowCount()>=1){
				$sql = "SELECT sh.Id, sh.HeadType, coalesce(HeadAmount,0,HeadAmount) as headamount, sh.Name  FROM SalaryHead sh , EmployeeSalaryDetails es where  es.HeadId=sh.Id and EmployeeId=? and sh.OrganizationId = ?  ";
				$query = $this->db->prepare($sql);
				$query->execute(array( $empid, $orgid));
				$status=true;
				$successMsg=" Record found";
				while($row = $query->fetch())
				{
					$res = array();
					$res['id'] = (int)$row->Id;
					$res['name'] = $row->Name;
					$res['headtype'] = $row->HeadType;
					$res['amount'] = (int)$row->headamount;
					$data[] = $res;
				}			
			}else{
				$sql = "SELECT * FROM SalaryHead WHERE OrganizationId = ?  ";
				$query = $this->db->prepare($sql);
				try{
					$query->execute(array( $orgid ));
					if($query->rowCount()>=1)
					{
						$status=true;
						$successMsg=$count." record found";
						while($row = $query->fetch())
						{
							$res = array();
							$res['id'] = (int)$row->Id;
							$res['name'] = $row->Name;
							$res['headtype'] = $row->HeadType;
							$res['amount'] = 0;
							
							$data[] = $res;
						}
					}else{
						$status=true;
						$successMsg = EMPLOYEE_MODULE_GETALL;
					}
				}catch(Exception $e) {
					$status=false;
					$errorMsg = 'Message: ' .$e->getMessage();
				}
				
				
				$allowance=0;
				$sql1 = "SELECT * FROM GradeBenefitChild gb, GradeMaster gm where gm.Id=gb.GradeId and OrganizationId=? and gm.Id=? group by GradeId";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array($orgid, $gradeid));
				while($row1 = $query1->fetch())
				{
					$allowance = $row1->BenefitAmount; 
					for($i=0; $i<count($data); $i++)
					{
						if($data[$i]['id']==$row1->BenefitId){
							$data[$i]['amount'] = (int)$row1->BenefitAmount; 
						}
					}	
				}
				
				$sql1 = "SELECT * FROM SalaryTypeMaster WHERE OrganizationId = ? and SalaryApply <= CURDATE() and DivisionId=?  and GradeId=? and ((? between if(exptype=0, 0, 999) and EmployeeExperience) or (? between EmployeeExperience and if(exptype=0, 0, 999))) limit 1";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array( $orgid, $division, $gradeid, $preexp, $preexp));
				$headid="0";
				if($query1->rowCount()>0)
				{
					$row1 = $query1->fetch();
					$sql2 = "SELECT * FROM SalaryTypeChild WHERE SalaryId=? order by SalaryHeadId";
					$query2 = $this->db->prepare($sql2);
					$query2->execute(array( $row1->Id));
					$monthly =  $row1->SalaryAmount;
					$salaryamt=$row1->SalaryAmount;
					$salarytype=$row1->Id;
					while($row2 = $query2->fetch())
					{
						$amount = ($row2->IsPercent)?$row2->SalaryPercent:round((($monthly*$row2->SalaryPercent)/100),1);
						for($i=0; $i<count($data); $i++)
						{
							if($data[$i]['id']==$row2->SalaryHeadId){
								$data[$i]['amount'] = (int)$amount; 
							}
						}	
					}
				}
			}
		}catch(Exception $e) {
			$status=false;
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
		$result["data"] =$data;
		$result["grosssalary"] =$salaryamt;
		$result["salarytype"] =$salarytype;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
	}
	public function getEmployeeSalaryDetails($request)
	{
		$result = array();
		$count=0; $errorMsg=""; $successMsg=""; $status=false;
		$data = array();
		$mid   = $request[0];	//USER ID CONTAINS IN ARRAY FIRST VALUE;
		$orgid = $request[1];	//ORG ID CONTAINS IN ARRAY SECOND VALUE;
		$empid = $request[2];	//EMPLOYEE ID CONTAINS IN ARRAY SECOND VALUE;
		$gradeid = $request[3];
		$salaryamt= $grossalary = $request[4];
		$incentive = $request[5];
		$experience = $request[6];
		$division = $request[7];
		$department = $request[8];
		$preexp = $request[9];
		
		$allowance=0; $salarytype=0;
		$sql11 = "SELECT * FROM EmployeeSalaryDetails WHERE EmployeeId = ?  ";
		$query11 = $this->db->prepare($sql11);
		try{
			$query11->execute(array( $empid ));
			if($query11->rowCount()>=1){
				//$sql = "SELECT sh.Id, sh.HeadType, coalesce(HeadAmount,0,HeadAmount) as headamount, sh.Name  FROM SalaryHead sh LEFT JOIN EmployeeSalaryDetails es ON  es.HeadId=sh.Id where EmployeeId=? and sh.OrganizationId = ?   and es.OrganizationId=?";
				
				$sql = "SELECT sh.Id, sh.HeadType, coalesce(HeadAmount,0,HeadAmount) as headamount, sh.Name  FROM SalaryHead sh , EmployeeSalaryDetails es where  es.HeadId=sh.Id and EmployeeId=? and sh.OrganizationId = ?  and es.OrganizationId=?";
				$query = $this->db->prepare($sql);
				$query->execute(array( $empid, $orgid, $orgid ));
				$status=true;
				$successMsg=" Record found";
				while($row = $query->fetch())
				{
					$res = array();
					$res['id'] = (int)$row->Id;
					$res['name'] = $row->Name;
					$res['headtype'] = $row->HeadType;
					$res['amount'] =(int) $row->headamount;
					$data[] = $res;
				}			
			}else{
				
				$sql1 = "SELECT * FROM GradeBenefitChild gb, GradeMaster gm where gm.Id=gb.GradeId and OrganizationId=? and gm.Id=? group by GradeId";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array($orgid, $gradeid));
				while($row1 = $query1->fetch())
				{
					$allowance = $row1->BenefitAmount; 
					for($i=0; $i<count($data); $i++)
					{
						if($data[$i]['id']==$row1->BenefitId){
							$data[$i]['amount'] = (int)$row1->BenefitAmount; 
						}
					}	
				}
				
				$sql1 = "SELECT SalaryType FROM SalaryDistributionChild WHERE GradeId=? and (? between SalaryRangeMin and if(SalaryRangeMax=0,99999999,SalaryRangeMax)) and PayPattern=? and ((? between if(ExpType=0, 0, 999) and ExpYears) or (? between ExpYears and if(ExpType=0, 0, 999))) limit 1";
				$query1 = $this->db->prepare($sql1);
				$query1->execute(array( $gradeid, $grossalary, $incentive, $experience, $experience));
				$headid="0";
				if($query1->rowCount()>0)
				{
					$row1 = $query1->fetch();
					$sql2 = "SELECT * FROM SalaryTypeChild WHERE SalaryId=? order by SalaryHeadId";
					$query2 = $this->db->prepare($sql2);
					$query2->execute(array( $row1->SalaryType));
					$monthly = $grossalary-$allowance;
					$salarytype=$row1->Id;
					while($row2 = $query2->fetch())
					{
						$amount = ($row2->IsPercent)?$row2->SalaryPercent:round(($monthly*$row2->SalaryPercent)/100);
						for($i=0; $i<count($data); $i++)
						{
							if($data[$i]['id']==$row2->SalaryHeadId){
								$data[$i]['amount'] = (int) $amount; 
							}
						}	
					}
				}
			}
			$sql = "SELECT * FROM SalaryHead WHERE OrganizationId = ?  and Id not in (SELECT HeadId FROM EmployeeSalaryDetails WHERE EmployeeId = ?)";
				$query = $this->db->prepare($sql);
				try{
					$query->execute(array( $orgid ,$empid));
					if($query->rowCount()>=1)
					{
						$status=true;
						$successMsg=$count." record found";
						while($row = $query->fetch())
						{
							$res = array();
							$res['id'] = (int)$row->Id;
							$res['name'] = $row->Name;
							$res['headtype'] = $row->HeadType;
							$res['amount'] = 0;
							
							$data[] = $res;
						}
					}else{
						$status=true;
						$successMsg = EMPLOYEE_MODULE_GETALL;
					}
				}catch(Exception $e) {
					$status=false;
					$errorMsg = 'Message: ' .$e->getMessage();
				}
		}catch(Exception $e) {
			$status=false;
			$errorMsg = 'Message: ' .$e->getMessage();
		}
		
		$result["data"] =$data;
		$result["grosssalary"] =$salaryamt;
		$result["salarytype"] =$salarytype;
		$result['status']=$status;
		$result['successMsg']=$successMsg;
		$result['errorMsg']=$errorMsg;
		
		return $result;
	}
	
}
